% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register_font.R
\name{register_font}
\alias{register_font}
\alias{registry_fonts}
\alias{clear_registry}
\title{Register font collections as families}
\usage{
register_font(
  name,
  plain,
  bold = plain,
  italic = plain,
  bolditalic = plain,
  features = font_feature()
)

registry_fonts()

clear_registry()
}
\arguments{
\item{name}{The name the collection will be known under (i.e. \emph{family})}

\item{plain, bold, italic, bolditalic}{Fontfiles for the different faces of the
collection. can either be a filepath or a list containing a filepath and an
index (only for font files containing multiple fonts). If not given it will
default to the \code{plain} specification.}

\item{features}{A \code{\link{font_feature}} object describing the specific OpenType
font features to turn on for the registered font.}
}
\value{
\code{register_font()} and \code{clear_registry()} returns \code{NULL} invisibly.
\code{registry_fonts()} returns a data table in the same style as \code{\link[=system_fonts]{system_fonts()}}
though less detailed and not based on information in the font file.
}
\description{
By design, systemfonts searches the fonts installed natively on the system.
It is possible, however, to register other fonts from e.g. font packages or
local font files, that will get searched before searching any installed
fonts. You can always get an overview over all registered fonts with the
\code{registry_fonts()} function that works as a registry focused analogue to
\code{\link[=system_fonts]{system_fonts()}}. If you wish to clear out the registry, you can either
restart the R session or call \code{clear_registry()}.
}
\details{
\code{register_font} also makes it possible to use system fonts with traits that
is not covered by the graphic engine in R. In plotting operations it is only
possible to specify a family name and whether or not the font should be bold
and/or italic. There are numerous fonts that will never get matched to this,
especially because bold is only one of many weights.

Apart from granting a way to use new varieties of fonts, font registration
also allows you to override the default \code{sans}, \code{serif}, and \code{mono} mappings,
simply by registering a collection to the relevant default name. As
registered fonts are searched first it will take precedence over the default.
}
\section{Font matching}{
During font matching, systemfonts has to look in three different locations.
The font registry (populated by \code{\link[=register_font]{register_font()}}/\code{\link[=register_variant]{register_variant()}}), the
local fonts (populated with \code{\link[=add_fonts]{add_fonts()}}/\code{\link[=scan_local_fonts]{scan_local_fonts()}}), and the
fonts installed on the system. It does so in that order: registry > local >
installed.

The matching performed at each step also differs. The fonts in the registry
is only matched by family name. The local fonts are matched based on all the
provided parameters (family, weight, italic, etc) in a way that is local to
systemfonts, but try to emulate the system native matching. The installed
fonts are matched using the system native matching functionality on macOS and
Linux. On Windows the installed fonts are read from the system registry and
matched using the same approach as for local fonts. Matching will always find
a font no matter what you throw at it, defaulting to "sans" if nothing else
is found.
}

\examples{
# Create a random font collection
fonts <- system_fonts()
plain <- sample(which(!fonts$italic & fonts$weight <= 'normal'), 1)
bold <- sample(which(!fonts$italic & fonts$weight > 'normal'), 1)
italic <- sample(which(fonts$italic & fonts$weight <= 'normal'), 1)
bolditalic <- sample(which(fonts$italic & fonts$weight > 'normal'), 1)
register_font(
  'random',
  plain = list(fonts$path[plain], fonts$index[plain]),
  bold = list(fonts$path[bold], fonts$index[bold]),
  italic = list(fonts$path[italic], fonts$index[italic]),
  bolditalic = list(fonts$path[bolditalic], fonts$index[bolditalic])
)

# Look at your creation
registry_fonts()

# Reset
clear_registry()

}
