% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracks.R
\name{track}
\alias{track}
\alias{track_guitar}
\alias{track_tc}
\alias{track_bc}
\alias{track_bass}
\title{Create a music track}
\usage{
track(
  phrase,
  clef = "treble_8",
  key = NA,
  tab = TRUE,
  tuning = "standard",
  voice = 1,
  lyrics = NA
)

track_guitar(
  phrase,
  clef = "treble_8",
  key = NA,
  tab = TRUE,
  tuning = "standard",
  voice = 1,
  lyrics = NA
)

track_tc(phrase, key = NA, voice = 1, lyrics = NA)

track_bc(phrase, key = NA, voice = 1, lyrics = NA)

track_bass(phrase, key = NA, voice = 1, lyrics = NA)
}
\arguments{
\item{phrase}{a phrase object.}

\item{clef}{character, include a music staff with the given clef. \code{NA} to
suppress. See details.}

\item{key}{character, key signature for music staff. See details.}

\item{tab}{logical, include tablature staff. \code{NA} to suppress.}

\item{tuning}{character, pitches describing the instrument string tuning or
a predefined tuning ID. See \code{\link[=tunings]{tunings()}}.
Defaults to standard guitar tuning; not relevant if tablature staff is
suppressed.}

\item{voice}{integer, ID indicating the unique voice \code{phrase()} belongs
to within a single track (another track may share the same tab/music staff
but have a different voice ID). Up to two voices are supported per track.}

\item{lyrics}{a lyrics object or \code{NA}. See details.}
}
\value{
a tibble data frame
}
\description{
Create a music track from a collection of musical phrases.
}
\details{
Musical phrases generated by \code{\link[=phrase]{phrase()}} are fortified in a track table. All
tracks are stored as track tables, one per row, even if that table consists
of a single track. \code{track()} creates a single-entry track table. See
\code{\link[=trackbind]{trackbind()}} for merging single tracks into a multi-track table. This is row
binding that also properly preserves phrase and track classes.

There are various \verb{track_*} functions offering sensible defaults based on the
function suffix. The base \code{track()} function is equivalent to
\code{track_guitar()}. See examples. Setting \code{clef = NA} or \code{tab = NA} suppresses
the music staff or tablature staff, respectively. By default \code{key = NA}, in
which case its inherits the global key from the \code{key} argument of various
sheet music rendering functions. If planning to bind two tracks as one where
they are given \code{voice = 1} and \code{voice = 2}, respectively, they must also have
a common key, even if \code{key = NA}.

\code{lyrics} should only be used for simple tracks that do not contain repeats.
You also need to ensure the timesteps for \code{lyrics} align with those of
\code{phrase()} in advance. Additionally, LilyPond does not engrave lyrics at
rests or tied notes (excluding first note in tied sequence) so if Therefore,
if \code{phrase()} contains rests and tied notes then the lyrics object should be
subset to exclude these timesteps as well. This is in contrast to using
\verb{render_music*} functions, which handle this automatically for music objects.
}
\examples{
x <- phrase("c ec'g' ec'g'", "4 4 2", "5 4 4")
track(x) # same as track_guitar(x); 8va treble clef above tab staff
track_tc(x) # treble clef sheet music, no tab staff
track_bc(x) # bass clef sheet music, no tab staff

x <- phrase("c, g,c g,c", "4 4 2", "3 2 2")
track_bass(x) # includes tab staff and standard bass tuning
}
\seealso{
\code{\link[=phrase]{phrase()}}, \code{\link[=score]{score()}}
}
