% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abnormal_by_marked.R
\name{abnormal_by_marked}
\alias{abnormal_by_marked}
\alias{count_abnormal_by_marked}
\alias{s_count_abnormal_by_marked}
\alias{a_count_abnormal_by_marked}
\title{Count patients with marked laboratory abnormalities}
\usage{
count_abnormal_by_marked(
  lyt,
  var,
  category = list(single = "SINGLE", last_replicated = c("LAST", "REPLICATED")),
  variables = list(id = "USUBJID", param = "PARAM", direction = "abn_dir"),
  na_str = default_na_str(),
  nested = TRUE,
  ...,
  .stats = "count_fraction",
  .stat_names = NULL,
  .formats = list(count_fraction = format_count_fraction),
  .labels = NULL,
  .indent_mods = NULL
)

s_count_abnormal_by_marked(
  df,
  .var = "AVALCAT1",
  .spl_context,
  category = list(single = "SINGLE", last_replicated = c("LAST", "REPLICATED")),
  variables = list(id = "USUBJID", param = "PARAM", direction = "abn_dir"),
  ...
)

a_count_abnormal_by_marked(
  df,
  ...,
  .stats = NULL,
  .stat_names = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout that analyses will be added to.}

\item{category}{(\code{list})\cr a list with different marked category names for single
and last or replicated.}

\item{variables}{(named \code{list} of \code{string})\cr list of additional analysis variables.}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{nested}{(\code{flag})\cr whether this layout instruction should be applied within the existing layout structure _if
possible (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split.
underneath analyses, which is not allowed.}

\item{...}{additional arguments for the lower level functions.}

\item{.stats}{(\code{character})\cr statistics to select for the table.

Options are: \verb{'count_fraction', 'count_fraction_fixed_dp'}}

\item{.stat_names}{(\code{character})\cr names of the statistics that are passed directly to name single statistics
(\code{.stats}). This option is visible when producing \code{\link[rtables:data.frame_export]{rtables::as_result_df()}} with \code{make_ard = TRUE}.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{"auto"} setting.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var, var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{.spl_context}{(\code{data.frame})\cr gives information about ancestor split states
that is passed by \code{rtables}.}
}
\value{
\itemize{
\item \code{count_abnormal_by_marked()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_count_abnormal_by_marked()} to the table layout.
}

\itemize{
\item \code{s_count_abnormal_by_marked()} returns statistic \code{count_fraction} with \verb{Single, not last},
\verb{Last or replicated}, and \code{Any} results.
}

\itemize{
\item \code{a_count_abnormal_by_marked()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The analyze function \code{\link[=count_abnormal_by_marked]{count_abnormal_by_marked()}} creates a layout element to count patients with marked laboratory
abnormalities for each direction of abnormality, categorized by parameter value.

This function analyzes primary analysis variable \code{var} which indicates whether a single, replicated,
or last marked laboratory abnormality was observed. Levels of \code{var} to include for each marked lab
abnormality (\code{single} and \code{last_replicated}) can be supplied via the \code{category} parameter. Additional
analysis variables that can be supplied as a list via the \code{variables} parameter are \code{id} (defaults
to \code{USUBJID}), a variable to indicate unique subject identifiers, \code{param} (defaults to \code{PARAM}), a
variable to indicate parameter values, and \code{direction} (defaults to \code{abn_dir}), a variable to indicate
abnormality directions.

For each combination of \code{param} and \code{direction} levels, marked lab abnormality counts are calculated
as follows:
\itemize{
\item \verb{Single, not last} & \verb{Last or replicated}: The number of patients with \verb{Single, not last}
and \verb{Last or replicated} values, respectively.
\item \code{Any}: The number of patients with either single or replicated marked abnormalities.
}

Fractions are calculated by dividing the above counts by the number of patients with at least one
valid measurement recorded during the analysis.

Prior to using this function in your table layout you must use \code{\link[rtables:split_rows_by]{rtables::split_rows_by()}} to create two
row splits, one on variable \code{param} and one on variable \code{direction}.
}
\section{Functions}{
\itemize{
\item \code{count_abnormal_by_marked()}: Layout-creating function which can take statistics function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

\item \code{s_count_abnormal_by_marked()}: Statistics function for patients with marked lab abnormalities.

\item \code{a_count_abnormal_by_marked()}: Formatted analysis function which is used as \code{afun}
in \code{count_abnormal_by_marked()}.

}}
\note{
\verb{Single, not last} and \verb{Last or replicated} levels are mutually exclusive. If a patient has
abnormalities that meet both the \verb{Single, not last} and \verb{Last or replicated} criteria, then the
patient will be counted only under the \verb{Last or replicated} category.
}
\examples{
library(dplyr)

df <- data.frame(
  USUBJID = as.character(c(rep(1, 5), rep(2, 5), rep(1, 5), rep(2, 5))),
  ARMCD = factor(c(rep("ARM A", 5), rep("ARM B", 5), rep("ARM A", 5), rep("ARM B", 5))),
  ANRIND = factor(c(
    "NORMAL", "HIGH", "HIGH", "HIGH HIGH", "HIGH",
    "HIGH", "HIGH", "HIGH HIGH", "NORMAL", "HIGH HIGH", "NORMAL", "LOW", "LOW", "LOW LOW", "LOW",
    "LOW", "LOW", "LOW LOW", "NORMAL", "LOW LOW"
  )),
  ONTRTFL = rep(c("", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y"), 2),
  PARAMCD = factor(c(rep("CRP", 10), rep("ALT", 10))),
  AVALCAT1 = factor(rep(c("", "", "", "SINGLE", "REPLICATED", "", "", "LAST", "", "SINGLE"), 2)),
  stringsAsFactors = FALSE
)

df <- df \%>\%
  mutate(abn_dir = factor(
    case_when(
      ANRIND == "LOW LOW" ~ "Low",
      ANRIND == "HIGH HIGH" ~ "High",
      TRUE ~ ""
    ),
    levels = c("Low", "High")
  ))

# Select only post-baseline records.
df <- df \%>\% filter(ONTRTFL == "Y")
df_crp <- df \%>\%
  filter(PARAMCD == "CRP") \%>\%
  droplevels()
full_parent_df <- list(df_crp, "not_needed")
cur_col_subset <- list(rep(TRUE, nrow(df_crp)), "not_needed")
spl_context <- data.frame(
  split = c("PARAMCD", "GRADE_DIR"),
  full_parent_df = I(full_parent_df),
  cur_col_subset = I(cur_col_subset)
)

map <- unique(
  df[df$abn_dir \%in\% c("Low", "High") & df$AVALCAT1 != "", c("PARAMCD", "abn_dir")]
) \%>\%
  lapply(as.character) \%>\%
  as.data.frame() \%>\%
  arrange(PARAMCD, abn_dir)

basic_table() \%>\%
  split_cols_by("ARMCD") \%>\%
  split_rows_by("PARAMCD") \%>\%
  summarize_num_patients(
    var = "USUBJID",
    .stats = "unique_count"
  ) \%>\%
  split_rows_by(
    "abn_dir",
    split_fun = trim_levels_to_map(map)
  ) \%>\%
  count_abnormal_by_marked(
    var = "AVALCAT1",
    variables = list(
      id = "USUBJID",
      param = "PARAMCD",
      direction = "abn_dir"
    )
  ) \%>\%
  build_table(df = df)

basic_table() \%>\%
  split_cols_by("ARMCD") \%>\%
  split_rows_by("PARAMCD") \%>\%
  summarize_num_patients(
    var = "USUBJID",
    .stats = "unique_count"
  ) \%>\%
  split_rows_by(
    "abn_dir",
    split_fun = trim_levels_in_group("abn_dir")
  ) \%>\%
  count_abnormal_by_marked(
    var = "AVALCAT1",
    variables = list(
      id = "USUBJID",
      param = "PARAMCD",
      direction = "abn_dir"
    )
  ) \%>\%
  build_table(df = df)

}
\keyword{internal}
