% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tgve_server.R
\name{tgve_server}
\alias{tgve_server}
\title{Start a TGVE instance server}
\usage{
tgve_server(
  path = Sys.getenv("TEMP_path_ENV"),
  port = 8000,
  host = "127.0.0.1",
  background = FALSE,
  run = TRUE
)
}
\arguments{
\item{path}{location of TGVE path to be served by plumber.}

\item{port}{to serve from.}

\item{host}{host to pass to plumber default `http://127.0.0.1`
to `FALSE`.}

\item{background}{run the R process in the background using `callr`,
defaults to `TRUE`.}

\item{run}{whether to start the server, defaults to `TRUE`. If
not, then the created server will be returned.}
}
\value{
the valude returned depends on: (1) `run`, if it is FALSE then
an instance of `plumber::pr`, (2) if `run` is true and `background` is TRUE
the `plumber::pr` instance is started and its process is returned, and
(3) if `run` is TRUE and `background` is FALSE then a message is displayed
showing the blocking `plumber::pr` instance's `path`, `port` and `host`.
}
\description{
The function accepts a `path` to get a directory containing an instance of
TGVE, by default this is done via `TEMP_DIR_ENV` env variable. If neither
is given then the function copies a clean copy of the bundled
TGVE version into a temporary directory.
}
\examples{
{
# This will run in the background using `callr`
ps = tgve_server(background = TRUE)
Sys.sleep(2)
ps$kill()
}
}
