% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_geom.R
\name{geom_sphere}
\alias{geom_sphere}
\title{Create sphere geometry}
\usage{
geom_sphere(name, radius, position = c(0, 0, 0), layer = 1,
  group = NULL, value = NULL, time_stamp = NULL)
}
\arguments{
\item{name}{unique string in a scene to tell apart from different objects}

\item{radius}{size of sphere}

\item{position}{x,y,z location of the sphere}

\item{layer}{visibility of the geometry, used when there are multiple cameras 1 is visible for all cameras}

\item{group}{a GeomGroup object}

\item{value, time_stamp}{color of the sphere, used for animation/color rendering}
}
\description{
Create sphere geometry
}
\examples{
# Create a sphere with animation
g = lapply(1:10, function(ii){
  v = rep(ii, 10)
  v[1:ii] = 1:ii
  geom_sphere(paste0('s', ii), ii, value = v, position = c(11 * ii, 0,0), time_stamp = (1:10)/10)
})
threejs_brain(.list = g, control_presets = 'animation',
              value_range = c(0, 10), time_range = c(0.1, 1))
}
