% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_generics.R, R/mod_nhpp.R
\name{BMDL}
\alias{BMDL}
\alias{BMDL.default}
\alias{BMDL.nhpp}
\title{Bayesian Maximum Descriptive Length}
\usage{
BMDL(object, ...)

\method{BMDL}{default}(object, ...)

\method{BMDL}{nhpp}(object, ...)
}
\arguments{
\item{object}{any object from which a log-likelihood value, or a
   contribution to a log-likelihood value, can be extracted.}

\item{...}{some methods for this generic function require additional
   arguments.}
}
\value{
A \code{double} vector of length 1
}
\description{
Generic function to compute the Bayesian Maximum Descriptive Length for a
changepoint detection model.
}
\details{
Currently, the BMDL function is only defined for the NHPP model
(see \code{\link[=fit_nhpp]{fit_nhpp()}}).
Given a changepoint set \eqn{\tau}, the BMDL is:
\deqn{
   BMDL(\tau, NHPP(y | \hat{\theta}_\tau) = 
   P_{MDL}(\tau) - 2 \ln{ L_{NHPP}(y | \hat{\theta}_\tau) } 
   - 2 \ln{ g(\hat{\theta}_\tau) }
 }
where \eqn{P_{MDL}(\tau)} is the \code{\link[=MDL]{MDL()}} penalty.
}
\examples{
# Compute the BMDL
BMDL(fit_nhpp(DataCPSim, tau = NULL))
BMDL(fit_nhpp(DataCPSim, tau = c(365, 830)))
}
\seealso{
Other penalty-functions: 
\code{\link{HQC}()},
\code{\link{MBIC}()},
\code{\link{MDL}()},
\code{\link{SIC}()}
}
\concept{penalty-functions}
