% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-like.R
\name{count_at}
\alias{count_at}
\title{Count by multiple variables}
\usage{
count_at(
  .tbl,
  .vars,
  .grouping = vars(),
  label_style = "long",
  long_label_column_names = c("variable", "category"),
  column_names = c("n", "rel", "percent"),
  na_label = "missing",
  percentage_label_decimal_places = 1,
  add_grouping = T,
  na.rm = F
)
}
\arguments{
\item{.tbl}{A data frame}

\item{.vars}{A list of variables (created using vars()) for which \code{\link{count_by}} is to be called}

\item{.grouping}{Additional grouping to apply prior to counting}

\item{label_style}{Character vector containing one of "wide" and "long" or both.\itemize{
\item "wide": Include labels in wide format, i.e., for each variable one column named as variable
and giving the label for the corresponding count, but NA for all rows from different variables
\item "long": Include two meta columns, one giving the variable that is counted (value from .vars),
the second giving the label (which value/category of the variable is counted?).
}}

\item{long_label_column_names}{Character vector of size 2: If label_style contains "long",
the names for the additional meta columns for variable and category}

\item{column_names}{vector if size 1 to 3, giving the names of (in order if unnamed, or named with n, rel, percent)
the column containing the count, the relative proportion, and the latter formatted as a percent label.
If a name is not contained, it will not be added (requires named vector).}

\item{na_label}{If na.rm=F, label to use for counting NA values}

\item{percentage_label_decimal_places}{Decimal precision of the percent label}

\item{add_grouping}{Shall a pre-existing grouping be preserved for counting (adding the newly specified grouping)?
Default is yes, which differs from group_by.}

\item{na.rm}{Shall NA values be removed prior to counting?}
}
\value{
A data frame concatenated from individual count_by results, with labels as per label_style.
}
\description{
Count by multiple variables
}
\examples{
library(magrittr)
library(datasets)
library(dplyr)
mtcars \%>\% count_at(vars(gear, cyl))
}
