#' ACIC2019 High Dimensional Test Dataset
#'
#' Dataset from the "Data Challenge" for the Atlantic Causal Inference Conference 2019.
#'
#' @format A data frame with 2000 observations, and 187 variables.
#' \describe{
#'   \item{Y}{Outcome variable}
#'   \item{A}{Treatment variable}
#'   \item{V1,V2,V3,V4,V5,V6,V7,V8,V9,V10,V11,V12,V13,V14,V15,V16,V17,V18,V19,V20,V21,V22,V23,V24,V25,V26,V27,V28,V29,V30,V31,V32,V33,V34,V35,V36,V37,V38,V39,V40,V41,V42,V43,V44,V45,V46,V47,V48,V49,V50,V51,V52,V53,V54,V55,V56,V57,V58,V59,V60,V61,V62,V63,V64,V65,V66,V67,V68,V69,V70,V71,V72,V73,V74,V75,V76,V77,V78,V79,V80,V81,V82,V83,V84,V85,V86,V87,V88,V89,V90,V91,V92,V93,V94,V95,V96,V97,V98,V99,V100,V101,V102,V103,V104,V105,V106,V107,V108,V109,V110,V111,V112,V113,V114,V115,V116,V117,V118,V119,V120,V121,V122,V123,V124,V125,V126,V127,V128,V129,V130,V131,V132,V133,V134,V135,V136,V137,V138,V139,V140,V141,V142,V143,V144,V145,V146,V147,V148,V149,V150,V151,V152,V153,V154,V155,V156,V157,V158,V159,V160,V161,V162,V163,V164,V165,V166,V167,V168,V169,V170,V171,V172,V173,V174,V175,V176,V177,V178,V179,V180,V181,V182,V183,V184,V185}{Other covariates}
#'   ...
#' }
#' @source \url{https://www.mcgill.ca/epi-biostat-occh/seminars-events/event-archive/atlantic-causal-inference-conference-2019/data-challenge}
"highDim_testdataset3"

#' Example simulated dataset 1
#'
#' Simulated with \code{simulate_su_hill_data(...)}, see details.
#' Includes propensity score estimated using BART (\code{prop_score}), see source.
#'
#' \preformatted{set.seed(101)
#'  suhillsim1 <- simulate_su_hill_data(n = 100, treatment_linear = FALSE,  omega = 0, add_categorical = TRUE,
#'    coef_categorical_treatment = c(0,0,1),
#'    coef_categorical_nontreatment = c(-1,0,-1))
#' }
#'
#' @format See \code{?simulate_su_hill_data} for output format.
#' @source \url{https://github.com/bonStats/tidytreatment/tree/master/data-raw}
"suhillsim1"

#' Example model 1
#'
#' Model fit with simulated data from simulated dataset \code{suhillsim1}.
#'
#' Propensity score estimated and included \code{suhillsim1} for fitting the model.
#'
#' @format Object of type \code{BART::wbart}
#' @source \url{https://github.com/bonStats/tidytreatment/tree/master/data-raw}
"bartmodel1"

#' Model matrix used for \code{bartmodel1}
#'
#' Useful for testing tidytreatment package functions.
#'
#' @format Object of type \code{BART::wbart}
#' @source \url{https://github.com/bonStats/tidytreatment/tree/master/data-raw}
"bartmodel1_modelmatrix"

#' Example simulated dataset 2: with subject specific random effects
#'
#' Simulated with \code{simulate_su_hill_data(...)}, see details.
#'
#' \preformatted{set.seed(101)
#'  suhillsim1 <- simulate_su_hill_data(n = 100, treatment_linear = FALSE,  omega = 0, add_categorical = TRUE,
#'    coef_categorical_treatment = c(0,0,1),
#'    coef_categorical_nontreatment = c(-1,0,-1), sd_subjects = 2, n_subjects = 10)
#' }
#'
#' @format See \code{?simulate_su_hill_data} for output format.
#' @source \url{https://github.com/bonStats/tidytreatment/tree/master/data-raw}
"suhillsim2_ranef"

#' Example model 2
#'
#' Model fit with simulated data from simulated dataset \code{suhillsim1}.
#'
#' Propensity score estimated and included \code{suhillsim1} for fitting the model.
#'
#' @format Object of type \code{stan4bartFit}
#' @source \url{https://github.com/bonStats/tidytreatment/tree/master/data-raw}
#"stan4bartmodel2" # too large
