% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conama.R
\name{conama_text}
\alias{conama_text}
\title{Text summary of conformity (bulleted, formatted)}
\usage{
conama_text(
  df,
  classe = "2",
  only_violations = FALSE,
  decimal_mark = ",",
  big_mark = "."
)
}
\arguments{
\item{df}{Input data}

\item{classe}{CONAMA class label}

\item{only_violations}{If TRUE, list only parameters with violation}

\item{decimal_mark}{Decimal separator (default \code{","})}

\item{big_mark}{Thousands separator (default \code{"."})}
}
\value{
Character vector of lines (first line is a header, the rest are bullets).
}
\description{
Text summary of conformity (bulleted, formatted)
}
\examples{
\dontrun{
data("wq_demo", package = "tikatuwq")
cat(conama_text(wq_demo, classe = "2"), sep = "\n")
}

}
\seealso{
\code{\link[=conama_summary]{conama_summary()}}, \code{\link[=conama_report]{conama_report()}}
}
