% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Version.R
\name{.core_info}
\alias{.core_info}
\alias{.core_hash}
\title{\code{libtiledb} Information}
\usage{
.core_info()

.core_hash()
}
\value{
\code{.core_info()}: A named character vector with the following entries:
\itemize{
\item \dQuote{\code{version}}: \code{libtiledb} version
\item \dQuote{\code{libtype}}: type of \code{libtiledb} install; will be one
of \dQuote{\code{vendored}}, \dQuote{\code{system}}, or \dQuote{\code{unknown}}
}

\code{.core_hash()}: The \link[tools:md5sum]{MD5 hash} of the core info
}
\description{
Get version and install information of the core \code{libtiledb} install
}
\section{Checking the \code{libtiledb} information in downstream packages}{

These functions are designed to make it easy to test if the core
\code{libtiledb} install has changed. This is accomplished by adding a
build-time constant to cache the version of \code{libtiledb} was built with.
For example, in \code{zzz.R}, put the following line to cache the
\code{libtiledb} information during package build
\preformatted{
.built_with <- list(libtiledb = tiledb::.core_hash())
}
Then, in the \link[base:ns-hooks]{load hook}, add the following check
\preformatted{
.onLoad <- function(libname, pkgname) {
  if (.built_with$libtiledb != tiledb::.core_hash()) {
    warning("Core libtiledb has changed, please reinstall ", pkgname)
  }
}
}
This will throw a warning if \pkg{tiledb}, and therefore \code{libtiledb},
has changed between downstream package install and load
}

\examples{
.core_info()

.core_hash()

}
\keyword{internal}
