% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{t_unit}
\alias{t_unit}
\alias{t_unit.tdiff}
\alias{t_unit.difftime}
\alias{units.tdiff}
\title{Get Time Unit}
\usage{
t_unit(x, long = TRUE, valid = FALSE)

\method{t_unit}{tdiff}(x, long = TRUE, valid = FALSE)

\method{t_unit}{difftime}(x, long = TRUE, valid = FALSE)

\method{units}{tdiff}(x)
}
\arguments{
\item{x}{an object of \code{tdiff} class or an object coercible to it.}

\item{long}{a logical value, if \code{FALSE}, internal code
of time unit is returned; if \code{TRUE}, long (human-readable)
name is returned (\code{TRUE} by default).}

\item{valid}{a logical value, if \code{TRUE}, syntactically valid names
will be returned (\code{FALSE} by default). Currently,
has no impact as all unit names are syntactically valid.}
}
\value{
A character value.
}
\description{
\code{t_unit} method returns time unit of time difference object
as a character value, either in short form (most often single letter,
code used internally) or long form (name).

\code{\link[base]{units}} method for \code{tdiff} objects is equivalent
to \code{t_unit} with \code{x} argument only.
}
\details{
Time differences (for example differences between date-time indices) are internally
represented as number of seconds. However, the returned time unit is
automatically determined based on the resolution of the argument. If all time
differences are full hours or full minutes, appropriate unit is returned,
see Examples. For time differences that contain zeros and missing values only,
returned unit is a second.
}
\examples{
(x <- as.tdiff(1, "y"))
t_unit(x)
t_unit(x, FALSE)
(x <- as.tdiff(1, "q"))
t_unit(x)
t_unit(x, FALSE)
(x <- as.tdiff(1, "m"))
t_unit(x)
t_unit(x, FALSE)
(x <- as.tdiff(1, "w"))
t_unit(x)
t_unit(x, FALSE)
(x <- as.tdiff(1, "d"))
t_unit(x)
t_unit(x, FALSE)
(x <- as.tdiff(1, "h"))
t_unit(x)
t_unit(x, FALSE)
(x <- as.tdiff(1, "min"))
t_unit(x)
t_unit(x, FALSE)
(x <- as.tdiff(1, "s"))
t_unit(x)
t_unit(x, FALSE)
# automatic unit determination
(x <- as.tdiff(600, "s")) # ten minutes
t_unit(x)
t_unit(x, FALSE)
(x <- as.tdiff(7200, "s")) # two hours
t_unit(x)
t_unit(x, FALSE)

}
\seealso{
\link{tdiff}, \code{\link{ti_type}}.
}
