% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar.R
\name{year_frac}
\alias{year_frac}
\alias{yf2tind}
\title{Converting Time Indices to Year Fractions and Back}
\usage{
year_frac(x)

yf2tind(x, type = NULL, tz = NULL)
}
\arguments{
\item{x}{an object of \code{tind} class or an R object coercible to it
for \code{year_frac}, a numeric vector for \code{yf2tind}.}

\item{type}{a character value determining time index type
(\code{y} - years, \code{q} - quarters, \code{m} - months,
\code{w} - weeks, \code{d} - dates, \code{t} - date-time).}

\item{tz}{(optional) a character value determining the time zone (the default
\code{NULL} is interpreted as the system time zone).
See \code{\link{tzone}} documentation for information on time zones.}
}
\value{
A numeric vector for \code{year_frac} and \code{tind} for \code{yf2tind}.
Result is of the same length as argument.
}
\description{
\code{year_frac} computes year fraction corresponding to a time index.
\code{yf2tind} performs the reverse computation.
}
\details{
\code{year_fraction} returns numeric vector representing time indices
in the form year + year fraction. For years this is equivalent to
\code{as.numeric}. Year fraction is determined based on the index
within particular year (minus 1 for all indices except for date-time)
and the number of periods within the year.
E.g., \code{2001Q1} gives \code{2001} (\code{2001 + (1 - 1) / 4}),
\code{2001Q3} --- \code{2001.5} (\code{2001 + (3 - 1) / 4}),
\code{2010-04} (April 2010) --- \code{2010.25} (\code{2010 + (4 - 1) / 12}),
\code{2000-02-29} (60th day in 2000) --- \code{2000.1612}
(\code{2000 + (60 - 1) / 366}, 2000 was a leap year).
}
\note{
\code{year_frac} is not to be confused with a similarly called function
(\code{YEARFRAC}) found in popular spreadsheet software. In order to compute
differences between dates as year fractions use \code{\link{daycount_frac}}
function.
}
\examples{
year_frac(today())
year_frac(now())
yf2tind(2023.5, "y")
yf2tind(2023.5, "q")
yf2tind(2023.5, "m")
yf2tind(2023.5, "w")
yf2tind(2023.5, "d")
yf2tind(2023.5, "t")

}
\seealso{
\code{\link{daycount_frac}}.
}
