% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_det}
\alias{torch_det}
\title{Det}
\usage{
torch_det(self)
}
\arguments{
\item{self}{(Tensor) the input tensor of size \verb{(*, n, n)} where \code{*} is zero or more                batch dimensions.}
}
\description{
Det
}
\note{
\if{html}{\out{<div class="sourceCode">}}\preformatted{Backward through `det` internally uses SVD results when `input` is
not invertible. In this case, double backward through `det` will be
unstable in when `input` doesn't have distinct singular values. See
`~torch.svd` for details.
}\if{html}{\out{</div>}}
}
\section{det(input) -> Tensor }{


Calculates determinant of a square matrix or batches of square matrices.
}

\examples{
if (torch_is_installed()) {

A = torch_randn(c(3, 3))
torch_det(A)
A = torch_randn(c(3, 2, 2))
A
A$det()
}
}
