% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions-mixture_same_family.R
\name{distr_mixture_same_family}
\alias{distr_mixture_same_family}
\title{Mixture of components in the same family}
\usage{
distr_mixture_same_family(
  mixture_distribution,
  component_distribution,
  validate_args = NULL
)
}
\arguments{
\item{mixture_distribution}{\code{torch_distributions.Categorical}-like
instance. Manages the probability of selecting component.
The number of categories must match the rightmost batch
dimension of the \code{component_distribution}. Must have either
scalar \code{batch_shape} or \code{batch_shape} matching
\verb{component_distribution.batch_shape[:-1]}}

\item{component_distribution}{\code{torch_distributions.Distribution}-like
instance. Right-most batch dimension indexes component.}

\item{validate_args}{Additional arguments}
}
\description{
The \code{MixtureSameFamily} distribution implements a (batch of) mixture
distribution where all component are from different parameterizations of
the same distribution type. It is parameterized by a \code{Categorical}
selecting distribution" (over \code{k} component) and a component
distribution, i.e., a \code{Distribution} with a rightmost batch shape
(equal to \verb{[k]}) which indexes each (batch of) component.
}
\examples{
if (torch_is_installed()) {
# Construct Gaussian Mixture Model in 1D consisting of 5 equally
# weighted normal distributions
mix <- distr_categorical(torch_ones(5))
comp <- distr_normal(torch_randn(5), torch_rand(5))
gmm <- distr_mixture_same_family(mix, comp)
}
}
