% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/PlotWrapper.R,
%   R/accessor-methods.R
\docType{methods}
\name{dataTypes}
\alias{dataTypes}
\alias{dataTypes,PlotFeatureSet-method}
\alias{dataTypes,ggplot-method}
\alias{dataTypes,trellis-method}
\alias{dataTypes,gTree-method}
\alias{dataTypes,PlotFeatureSet-method}
\title{Accessor method for the variable types (slot "vartypes") of
    the plot object.}
\usage{
dataTypes(object)

\S4method{dataTypes}{PlotFeatureSet}(object)

\S4method{dataTypes}{ggplot}(object)

\S4method{dataTypes}{trellis}(object)

\S4method{dataTypes}{gTree}(object)

\S4method{dataTypes}{PlotFeatureSet}(object)
}
\arguments{
\item{object}{An object of class PlotFeatureSet, GGplotFeatureSet,
TrellisFeatureSet, ggplot, or trellis.}
}
\value{
A named list of variable types of the form list(x =
    "numeric", y = "factor", ...).
}
\description{
Get the variable types from a plot feature set
}
\examples{
library(ggplot2)
mt = datasets::mtcars
plt = qplot(mt$mpg, mt$cyl)
fs = makeFeatureSet(plt)
dataTypes(fs)

}
