% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classes.R
\docType{class}
\name{FeatureSet-class}
\alias{FeatureSet-class}
\alias{.FeatureSet}
\alias{show,FeatureSet-method}
\alias{ObjFeatureSet-class}
\alias{.ObjFeatureSet}
\alias{DFFeatureSet-class}
\alias{.DFFeatureSet}
\alias{PlotFeatureSet-class}
\alias{.PlotFeatureSet}
\alias{show,PlotFeatureSet-method}
\alias{GGplotFeatureSet-class}
\alias{.GGplotFeatureSet}
\alias{show,GGplotFeatureSet-method}
\alias{TrellisFeatureSet-class}
\alias{.TrellisFeatureSet}
\alias{GraphicsFeatureSet-class}
\alias{.GraphicsFeatureSet}
\alias{RmdFeatureSet-class}
\alias{.RmdFeatureSet}
\alias{show,RmdFeatureSet-method}
\title{FeatureSet (and Sub)-Classes}
\description{
Metadata inferred about R objects or dynamic documents is stored in
FeatureSet objects specific. Specific types of featuresets have specific additional
metadata they contain, beyond the standard metadata inferred about all results, and
represented by the core FeatureSet class.
}
\section{Slots}{

\describe{
\item{\code{user}}{character The user who submitted the result}

\item{\code{regdate}}{POSIXct The date/time the result was recorded}

\item{\code{analysispkg}}{list The R package associated with the result (because the
working directory was within the package's directory structure).}

\item{\code{uniqueid}}{character The uniqueid of the result}

\item{\code{tags}}{character Additional tags associated with the result}

\item{\code{analysisfile}}{character The .R file active when there result was recorded (RStudio IDE only)}

\item{\code{rstudioproject}}{character The RStudio project active when the result was recorded (RStudio IDE only)}

\item{\code{generatedin}}{character The uniqueid of the Rmd file the result was generated in, if applicable}

\item{\code{code}}{character The code used to generate the result (by default, as captured by histry)}

\item{\code{codeinfo}}{ScriptInfo the ScriptInfo for the code}

\item{\code{sessioninfo}}{sinfoOrList The session info at the time the result was recorded}

\item{\code{isplot}}{logical Whether the result is a plot}

\item{\code{fsetklass}}{character The FeatureSet subclass for the result}

\item{\code{trackrversion}}{character The exact version of the trackr package used to record the result.}

\item{\code{clineargs}}{character The commandline arguments passed to R when starting the session the result was recorded from}

\item{\code{resultURI}}{character The URI associated with the result, see featureset constructor documentation.}

\item{\code{extrametadata}}{list Any extra metadata associated with the result.}

\item{\code{klass}}{character The R object class of the result}

\item{\code{object}}{ANY The object itself, or NULL if the object is not available.}

\item{\code{vars}}{character The variable names for a data.frame result}

\item{\code{varclasses}}{character the variable classes for a data.frame result}

\item{\code{varsummaries}}{list summaries for}

\item{\code{object}}{ANY The object itself, or NULL if the object is not available.}

\item{\code{data}}{A list of data.frames containing the variables and observations used in the plot.}

\item{\code{titles}}{Title and subtitle of the plot object; a named list of the form list(main = "My title", sub = "My subtitle").}

\item{\code{varlabels}}{Variable labels of the plot object; a named list of the form list(x = "X axis label", y = "Y axis label", groups = list(...)). Note that non-empty labels are character vectors and may contain more than one entry.}

\item{\code{annotation.text}}{Annotation text of the plot object.}

\item{\code{vartypes}}{Variable types of the plot object; a named list of the form list(x = "numeric", y = "factor", ...).}

\item{\code{grouping}}{Grouping information on the plot object; a named list.}

\item{\code{coordsys}}{A character vector describing the coordinate system employed in the plot.}

\item{\code{nobs}}{An integer representing the number of observations in the plotted data.}

\item{\code{haslegend}}{A boolean indicating whether or not a legend is displayed in the plot.}

\item{\code{tags}}{A character vector of user-defined tags.}

\item{\code{code}}{R code to reproduce the plot, as a CodeDepends::Script object. May be empty.}

\item{\code{codeinfo}}{Information about the R code to reproduce the plot, as a CodeDepends::ScriptInfo object. May be empty.}

\item{\code{geom}}{A named list of parameters for geometric objects in each layer of the ggplot.}

\item{\code{stat}}{A named list of parameters for statistical transforms in each layer of the ggplot.}

\item{\code{position}}{A named list of positioning information in each layer of the ggplot.}

\item{\code{num.layers}}{An integer representing the number of layers in the plot.}
}}

