% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlo.R
\name{simulate_video}
\alias{simulate_video}
\title{Simulate latent and observed emotion scores for a single "video"}
\usage{
simulate_video(
  dt,
  num_steps,
  num_observables,
  eta_n,
  zeta_n,
  eta,
  zeta,
  sigma_q,
  sd_observable,
  loadings,
  window_size,
  emph = FALSE,
  emph.dur = 10,
  emph.prob = 0.5
)
}
\arguments{
\item{dt}{Numeric real.
The time step for the simulation (in minutes).}

\item{num_steps}{Numeric real.
Total length of the video (in minutes).}

\item{num_observables}{Numeric integer. 
The number of observables to generate per factor. Total number of observables generated is 2 x num_observables.}

\item{eta_n}{Numeric.
The eta parameter for the neutral state.}

\item{zeta_n}{Numeric.
The zeta parameter for the neutral state.}

\item{eta}{Numeric.
The eta parameter for the positive and negative emotions.}

\item{zeta}{Numeric.
The zeta parameter for the positive and negative emotions.}

\item{sigma_q}{Numeric.
The standard deviation of Dynamic Error of the q(t) function.}

\item{sd_observable}{Numeric.
The standard deviation of the measurement error.}

\item{loadings}{Numeric (default = 0.8).
The default initial loading of the latent variable on the observable variable.}

\item{window_size}{Numeric integer.
The window size for smoothing the observables.}

\item{emph}{Logical.
Whether to emphasize the effect of dominant emotion (default is FALSE).}

\item{emph.dur}{Numeric integer.
The duration of the emphasis (default is 10).}

\item{emph.prob}{Numeric.
The probability of the dominant emotion being emphasized (default is 0.5).}
}
\value{
A data frame (num_steps X (6 + num_observables)) containing the latent scores for neutral score, positive emotions, negative emotions and their derivatives, as well as smoothed versions of the observables.
}
\description{
This function simulates emotions in a video using the DLO model implemented as continuous time state space model. The function takes in several parameters, including the time step, number of steps, number of observables, and various model parameters. It returns a data frame containing the simulated emotions and their derivatives, as well as smoothed versions of the observables.
The initial state of the video is always the same. Neutral score is 0.5 and both positive and negative emotion score is 0.25. 
To simulate more realistic time series, there is an option of including a sudden jump in the emotion scores. This is done by emphasizing the effect of the dominant emotion during the period where the derivative of the latent variable is high. The observable value of the strongest emotion from the positive or negative group will spike in the next k time step (emph.dur). The probability of this happening is p at each time step in which the derivative of the latent variable is greater than 0.2. The jump is proportionate to the derivative of the latent variable and the sum of the observable values of the other emotions.
}
\examples{
simulate_video(dt = 0.01, num_steps = 50, num_observables = 4, 
               eta_n = 0.5, zeta_n = 0.5,
               eta = 0.5, zeta = 0.5,
               sigma_q = 0.1, sd_observable = 0.1,
               loadings = 0.8, window_size = 10)
}
