% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permcoef.R
\name{permcoef}
\alias{permcoef}
\title{Calculates permeability coefficients}
\usage{
permcoef(trans, conc0 = NULL, vol, area, units = c("cm^3", "cm^2", "h"))
}
\arguments{
\item{trans}{Data frame with the complete transport information of
interest species. Must be generated using
\code{\link{conc2frac}}.}

\item{conc0}{Initial concentration of the species in the feed solution. The
value may be extracted from transport information if the data
frame provided in \code{trans} is not normalized. See
\code{\link{conc2frac}} for details.}

\item{vol}{Volume of the feed solution.}

\item{area}{Membrane exposed area to the feed solution.}

\item{units}{Units in which volume, area and time are provided. Volume
and area are function's parameters while the time is
extracted from the \code{trans} data frame.}
}
\value{
Premeability coefficient for species in meters per second.
}
\description{
Permeability coefficients across a membrane as derived from integrated
Fick's law can be obtained from transport data according to the equation
\deqn{\ln{\Bigg(\frac{C}{C^0}\Bigg)}=
-\frac{P~a}{V}t} where \eqn{P} is the permeability coefficient, \eqn{a} is
the membrane exposed area, \eqn{C} and \eqn{C^0} are
the species concentrations at any time and at initial time in the feed phase,
respectively, and \eqn{V} is solution volume.
}
\details{
Species concentration units may be arbitrary as long as the permeability
coefficient is calculated using the change in concentration ratio which is,
as most ratios, adimensional
}
\author{
Cristhian Paredes, \email{craparedesca@unal.edu.co}

Eduardo Rodriguez de San Miguel, \email{erdsmg@unam.mx}
}
