% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulateDiscreteDistributions.R
\name{Bivariate_LSDsim}
\alias{Bivariate_LSDsim}
\title{Simulates from the bivariate logarithmic series distribution}
\usage{
Bivariate_LSDsim(N, p1, p2)
}
\arguments{
\item{N}{number of data points to be simulated}

\item{p1}{parameter \eqn{p_1} of the bivariate logarithmic series distribution}

\item{p2}{parameter \eqn{p_2} of the bivariate logarithmic series distribution}
}
\value{
An \eqn{N \times 2} matrix with \eqn{N} simulated values from the
 bivariate logarithmic series distribution
}
\description{
Simulates from the bivariate logarithmic series distribution
}
\details{
The probability mass function of a random vector \eqn{X=(X_1,X_2)' }
 following the bivariate logarithmic series distribution with parameters
 \eqn{0<p_1, p_2<1} with \eqn{p:=p_1+p_2<1} is given by
 \deqn{P(X_1=x_1,X_2=x_2)=\frac{\Gamma(x_1+x_2)}{x_1!x_2!}
 \frac{p_1^{x_1}p_2^{x_2}}{(-\log(1-p))},} for \eqn{x_1,x_2=0,1,2,\dots} such
 that \eqn{x_1+x_2>0}. The simulation proceeds in two steps: First, \eqn{X_1}
 is simulated from the modified logarithmic distribution with parameters
 \eqn{\tilde p_1=p_1/(1-p_2)} and \eqn{\delta_1=\log(1-p_2)/\log(1-p)}. Then
 we simulate \eqn{X_2} conditional on \eqn{X_1}. We note that
 \eqn{X_2|X_1=x_1} follows the  logarithmic series distribution with
 parameter \eqn{p_2} when \eqn{x_1=0}, and the  negative binomial
 distribution with parameters \eqn{(x_1,p_2)} when  \eqn{x_1>0}.
}
\examples{
set.seed(1)
p1 <- 0.15
p2 <- 0.3
N <- 100
#Simulate N realisations from the bivariate LSD
y <- Bivariate_LSDsim(N, p1, p2)
}
