% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aspect_importance.R
\name{plot.aspect_importance}
\alias{plot.aspect_importance}
\title{Function for plotting aspect_importance results}
\usage{
\method{plot}{aspect_importance}(
  x,
  ...,
  bar_width = 10,
  show_features = aspects_on_axis,
  aspects_on_axis = TRUE,
  add_importance = FALSE,
  digits_to_round = 2,
  text_size = 3
)
}
\arguments{
\item{x}{object of aspect_importance class}

\item{...}{other parameters}

\item{bar_width}{bar width}

\item{show_features}{if TRUE, labels on axis Y show aspect names, otherwise
they show features names}

\item{aspects_on_axis}{alias for \code{show_features} held for backwards 
compatibility}

\item{add_importance}{if TRUE, plot is annotated with values of aspects
importance}

\item{digits_to_round}{integer indicating the number of decimal places used
for rounding values of aspects importance shown on the plot}

\item{text_size}{size of labels annotating values of aspects importance,
if applicable}
}
\value{
a ggplot2 object
}
\description{
This function plots the results of aspect_importance.
}
\examples{
library("DALEX")

model_titanic_glm <- glm(survived == 1 ~
                         class+gender+age+sibsp+parch+fare+embarked,
                         data = titanic_imputed,
                         family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                               data = titanic_imputed[,-8],
                               y = titanic_imputed$survived == 1,
                               verbose = FALSE)

aspects <- list(wealth = c("class", "fare"),
                family = c("sibsp", "parch"),
                personal = c("gender", "age"),
                embarked = "embarked")

titanic_ai <- predict_aspects(explain_titanic_glm,
                  new_observation = titanic_imputed[1,],
                  variable_groups = aspects)
plot(titanic_ai)

}
