% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_long_wide.R
\name{ts_long}
\alias{ts_long}
\alias{ts_wide}
\title{Reshaping Multiple Time Series}
\usage{
ts_long(x)

ts_wide(x)
}
\arguments{
\item{x}{a ts-boxable time series, or a wide \code{data.frame},
\code{data.table}, or \code{tibble}.}
}
\value{
a ts-boxable object of the same class as \code{x}, i.e., an object of
class \code{ts}, \code{xts}, \code{zoo}, \code{zooreg}, \code{data.frame}, \code{data.table}, \code{tbl},
\code{tbl_ts}, \code{tbl_time}, \code{tis}, \code{irts} or \code{timeSeries}.
}
\description{
Functions to reshape multiple time series from 'wide' to 'long' and vice
versa. Note that long format data frames are ts-boxable objects, where wide
format data frames are not. \code{ts_long} automatically identifies a \strong{time}
column, and uses columns on the left as id columns.
}
\examples{
x <- ts_df(ts_c(mdeaths, fdeaths))
df.wide <- ts_wide(x)
df.wide
ts_long(df.wide)
}
