% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge.recipe}
\alias{merge.recipe}
\alias{merge.model_spec}
\title{Merge parameter grid values into objects}
\usage{
\method{merge}{recipe}(x, y, ...)

\method{merge}{model_spec}(x, y, ...)
}
\arguments{
\item{x}{A recipe or model specification object.}

\item{y}{A data frame or a parameter grid resulting from one of the
\verb{grid_*} functions. The column names should correspond to the parameter
names (or their annotations) in the object.}

\item{...}{Not used but required for S3 completeness.}
}
\value{
A tibble with a column \code{x} that has as many rows as were in \code{y}.
}
\description{
\code{merge()} can be used to easily update any of the arguments in a
\pkg{parsnip} model or recipe.
}
\examples{
\dontshow{if (tune:::should_run_examples(suggests = c("xgboost", "modeldata", "splines2"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(tibble)
library(recipes)
library(parsnip)
library(dials)

pca_rec <-
  recipe(mpg ~ ., data = mtcars) |>
  step_impute_knn(all_predictors(), neighbors = tune()) |>
  step_pca(all_predictors(), num_comp = tune())

pca_grid <-
  tribble(
    ~neighbors, ~num_comp,
             1,         1,
             5,         1,
             1,         2,
             5,         2
  )

merge(pca_rec, pca_grid)

spline_rec <-
  recipe(mpg ~ ., data = mtcars) |>
  step_spline_natural(disp, deg_free = tune("disp df")) |>
  step_spline_natural(wt, deg_free = tune("wt df"))

spline_grid <-
  tribble(
    ~"disp df", ~ "wt df",
    3,         3,
    5,         3,
    3,         5,
    5,         5
  )

merge(pca_rec, pca_grid)

data(hpc_data, package = "modeldata")

xgb_mod <-
  boost_tree(trees = tune(), min_n = tune()) |>
  set_engine("xgboost")

set.seed(254)
xgb_grid <-
  extract_parameter_set_dials(xgb_mod) |>
  finalize(hpc_data) |>
  grid_max_entropy(size = 3)

merge(xgb_mod, xgb_grid)
\dontshow{\}) # examplesIf}
}
\keyword{internal}
