% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lumberjack.R
\docType{class}
\name{lbj_cells-class}
\alias{lbj_cells-class}
\alias{lbj_cells}
\title{Logging object to use with the lumberjack package}
\format{
A reference class object
}
\description{
Logging object to use with the lumberjack package
}
\section{Methods}{

\describe{
\item{\code{add(meta, input, output)}}{Add logging info based on in- and output}

\item{\code{dump(file = NULL, verbose = TRUE, ...)}}{Dump logging info to csv file. 
All arguments in '...' except row.names are passed to 'write.csv'}

\item{\code{initialize(..., verbose = TRUE, label = "")}}{Create object. Optionally toggle verbosity.}

\item{\code{log_data()}}{Return logged data as a data.frame}
}}

\section{Details}{
 

This obeject can used with the function composition ('pipe') operator of the 
\code{\link[lumberjack]{lumberjack}} package. The logging is based on
validate's \code{\link{cells}} function. The output is written to a
\code{csv} file wich contains the following columns.
\tabular{lll}{
\code{step}           \tab\code{integer}  \tab Step number  \cr
\code{time}           \tab\code{POSIXct}  \tab Timestamp    \cr
\code{expr}           \tab\code{character}\tab Expression used on data \cr
\code{cells}          \tab\code{integer}  \tab Total nr of cells in dataset\cr
\code{available}      \tab\code{integer}  \tab Nr of non-NA cells\cr
\code{missing}        \tab\code{integer}  \tab Nr of empty (NA) cells\cr
\code{still_available}\tab\code{integer}  \tab Nr of cells still available after expr\cr
\code{unadapted}      \tab\code{integer}  \tab Nr of cells still available and unaltered\cr
\code{unadapted}      \tab\code{integer}  \tab Nr of cells still available and altered\cr
\code{imputed}        \tab\code{integer}  \tab Nr of cells not missing anymore\cr
}
}

\section{Note}{

This logger is suited only for operations that do not change the dimensions 
of the dataset.
}

\seealso{
Other loggers: 
\code{\link{lbj_rules-class}}
}
\concept{loggers}
