#ifndef  RF_STACK_PRE_DEFINED_H
#define  RF_STACK_PRE_DEFINED_H
#include "factor.h"
char stackIncomingArrays(char     mode,
                         uint     ntree,
                         uint     timeInterestSize,
                         uint     ytry,
                         uint     mtry,
                         double  *xWeight,
                         double  *yWeight,
                         uint     subjSize,
                         double  *subjWeight,
                         double  *xWeightStat,
                         uint     nodeSize,
                         uint     bootstrapSize,
                         uint     splitRule,
                         uint     quantileSize,
                         double  *quantile,
                         uint     ySize,
                         char    *rType,
                         uint     frSize,
                         uint    *subjIn,
                         uint     observationSize,
                         double **responseIn,
                         double **fresponseIn,
                         uint     xSize,
                         char    *xType,
                         uint     fobservationSize,
                         double **observationIn,
                         double **fobservationIn,
                         uint   **yIndex,
                         uint   **yIndexZero,
                         uint    *timeIndex,
                         uint    *startTimeIndex,
                         uint    *statusIndex,
                         double **masterTime,
                         uint    *masterTimeSize,
                         uint    *sortedTimeInterestSize,
                         uint   **startMasterTimeIndexIn,
                         uint   **masterTimeIndexIn,
                         uint    *ptnCount,
                         uint    *ySizeProxy,
                         uint    *yIndexZeroSize);
void unstackIncomingArrays(char    mode,
                           uint    ySize,
                           uint   *yIndex,
                           uint   *yIndexZero);
char stackIncomingResponseArrays(char     mode,
                                 uint     ySize,
                                 char    *rType,
                                 uint    *subjIn,
                                 uint     frSize,
                                 uint     observationSize,
                                 uint     fobservationSize,
                                 double **responseIn,
                                 double **fresponseIn,
                                 uint   **yIndex,
                                 uint   **yIndexZero,
                                 uint    *timeIndex,
                                 uint    *startTimeIndex,
                                 uint    *statusIndex,
                                 double **masterTime,
                                 uint    *masterTimeSize,
                                 uint    *sortedTimeInterestSize,
                                 uint   **startMasterTimeIndexIn,
                                 uint   **masterTimeIndexIn,
                                 uint    *ptnCount,
                                 uint    *ySizeProxy,
                                 uint    *yIndexZeroSize);
void unstackIncomingResponseArrays(char  mode,
                                   uint  ySize,
                                   uint *yIndex,
                                   uint *yIndexZero);
char stackPreDefinedCommonArrays(char          mode,
                                 uint          ntree,
                                 double       *subjWeight,
                                 uint          timeIndex,
                                 uint          startTimeIndex,
                                 uint          statusIndex,
                                 uint          bootstrapSize,
                                 uint        **bootstrapIn,
                                 uint          subjSize,
                                 uint          ptnCount,
                                 uint         *getTree,
                                 uint          observationSize,
                                 NodeBase      ****nodeMembership,
                                 TerminalBase  ****tTermMembership,
                                 NodeBase      ****pNodeMembership,
                                 TerminalBase  ****pTermMembership,
                                 LeafLinkedObj ****hTermMembership,
                                 TerminalBase  ****tTermList,
                                 NodeBase      ****pNodeList,
                                 TerminalBase  ****pTermList,
                                 char       ***bootMembershipFlag,
                                 char       ***oobMembershipFlag,
                                 uint       ***bootMembershipCount,
                                 uint       ***ibgMembershipIndex,
                                 uint       ***oobMembershipIndex,
                                 uint        **oobSize,
                                 uint        **ibgSize,
                                 uint       ***bootMembershipIndex,
                                 uint        **maxDepth,
                                 uint        **orderedTreeIndex,
                                 uint        **serialTreeIndex,
                                 NodeBase       ***root,
                                 uint        **nodeCount,
                                 LeafLinkedObj ***leafLinkedObjHead,
                                 LeafLinkedObj ***leafLinkedObjTail,
                                 uint        **pLeafCount,
                                 uint        **getTreeIndex,
                                 uint         *getTreeCount,
                                 uint         *subjWeightType,
                                 uint        **subjWeightSorted,
                                 uint         *subjWeightDensitySize,
                                 uint         *identityMembershipIndexSize,
                                 uint        **identityMembershipIndex);
void unstackPreDefinedCommonArrays(char             mode,
                                   uint             ntree,
                                   uint             timeIndex,
                                   uint             startTimeIndex,
                                   uint             statusIndex,
                                   uint             subjSize,
                                   uint             ptnCount,
                                   NodeBase          ***nodeMembership,
                                   TerminalBase      ***tTermMembership,
                                   NodeBase          ***pNodeMembership,
                                   TerminalBase      ***pTermMembership,
                                   LeafLinkedObj ***hTermMembership,
                                   TerminalBase      ***tTermList,
                                   NodeBase          ***pNodeList,
                                   TerminalBase      ***pTermList,
                                   char           **bootMembershipFlag,
                                   char           **oobMembershipFlag,
                                   uint           **bootMembershipCount,
                                   uint           **ibgMembershipIndex,
                                   uint           **oobMembershipIndex,
                                   uint            *oobSize,
                                   uint            *ibgSize,
                                   uint           **bootMembershipIndex,
                                   uint            *maxDepth,
                                   uint            *orderedTreeIndex,
                                   uint            *serialTreeIndex,
                                   NodeBase           **root,
                                   uint            *nodeCount,
                                   LeafLinkedObj  **leafLinkedObjHead,
                                   LeafLinkedObj  **leafLinkedObjTail,
                                   uint            *pLeafCount,
                                   uint            *getTreeIndex,
                                   uint             subjWeightType,
                                   uint            *subjWeightSorted,
                                   uint             identityMembershipIndexSize,
                                   uint            *identityMembershipIndex);
char stackPreDefinedRestoreArrays(uint   xSize,
                                  uint  *intrPredictor,
                                  uint   intrPredictorSize,
                                  char **importanceFlag);
void unstackPreDefinedRestoreArrays(uint  xSize,
                                    char *importanceFlag);
void stackPreDefinedPredictArrays(uint   ntree,
                                  uint   observationSize,
                                  uint  *identityMembershipIndexSize,
                                  uint **identityMembershipIndex,
                                  NodeBase      ****nodeMembership,
                                  TerminalBase  ****tTermMembership);
void unstackPreDefinedPredictArrays(uint   ntree,
                                    uint   observationSize,
                                    uint  identityMembershipIndexSize,
                                    uint *identityMembershipIndex,
                                    NodeBase      ***nodeMembership,
                                    TerminalBase  ***tTermMembership);
char checkInteraction(uint  xSize,
                      uint *intrPredictor,
                      uint  intrPredictorSize);
void stackWeights(double *weight,
                  uint    size,
                  uint   *weightType,
                  uint  **weightSorted,
                  uint   *weightDensitySize);
void unstackWeights(uint    weightType,
                    uint    size,
                    uint   *weightSorted);
double getMeanValue(double *value, uint size);
char stackAndInitializeTimeAndSubjectArrays(char     mode,
                                            uint     startTimeIndex,
                                            uint     observationSize,
                                            double **responseIn,
                                            uint     timeIndex,
                                            uint     timeInterestSize,
                                            uint    *subjIn,
                                            uint    *subjSize,
                                            double **masterTime,
                                            uint   **masterTimeIndexIn,
                                            uint   **startMasterTimeIndexIn,
                                            double **timeInterest,
                                            uint    *masterTimeSize,
                                            uint    *sortedTimeInterestSize,
                                            uint   **masterToInterestTimeMap,
                                            uint   **subjSlot,
                                            uint   **subjSlotCount,
                                            uint  ***subjList,
                                            uint   **caseMap,
                                            uint   **subjMap,
                                            uint    *subjCount);
void unstackTimeAndSubjectArrays(char     mode,
                                 uint     startTimeIndex,
                                 uint     observationSize,
                                 double  *masterTime,
                                 uint    *masterTimeIndexIn,
                                 uint     masterTimeSize,
                                 uint    *startMasterTimeIndexIn,
                                 uint    *masterToInterestTimeMap,
                                 uint    *subjSlot,
                                 uint    *subjSlotCount,
                                 uint   **subjList,
                                 uint    *caseMap,
                                 uint    *subjMap,
                                 uint     subjCount);
void stackFactorArrays(char    mode,
                       char   *rType,
                       char   *xType,
                       uint    ySize,
                       uint    xSize,
                       uint   *xLevelsCnt,
                       uint   *rTarget,
                       uint    rTargetCount,
                       uint    timeIndex,
                       uint    statusIndex,
                       uint   *rFactorCount,
                       uint   *xFactorCount,
                       uint  **rFactorMap,
                       uint  **xFactorMap,
                       uint  **rFactorIndex,
                       uint  **xFactorIndex,
                       uint  **rFactorSize,
                       uint  **xFactorSize,
                       uint   *rNonFactorCount,
                       uint   *xNonFactorCount,
                       uint  **rNonFactorMap,
                       uint  **xNonFactorMap,
                       uint  **rNonFactorIndex,
                       uint  **xNonFactorIndex,
                       uint  **rTargetFactor,
                       uint  **rTargetNonFactor,
                       uint   *rTargetFactorCount,
                       uint   *rTargetNonFactorCount,
                       uint ***xLevels);
void stackFactorGeneric(char    respFlag,
                        uint    size,
                        char   *type,
                        uint  **factorMap,
                        uint   *factorCount,
                        uint  **factorIndex,
                        uint  **factorSize,
                        uint  **nonfactorMap,
                        uint   *nonfactorCount,
                        uint  **nonfactorIndex);
void unstackFactorArrays(char     mode,
                         uint     ntree,
                         uint     ySize,
                         uint     xSize,
                         uint    *rTarget,
                         uint     rTargetCount,
                         uint    *rTargetFactor,
                         uint    *rTargetNonFactor,
                         uint     timeIndex,
                         uint     statusIndex,
                         uint     rFactorCount,
                         uint     xFactorCount,
                         uint    *rFactorMap,
                         uint    *xFactorMap,
                         uint    *rFactorIndex,
                         uint    *xFactorIndex,
                         uint    *rFactorSize,
                         uint    *xFactorSize,
                         uint     rNonFactorCount,
                         uint     xNonFactorCount,
                         uint    *rNonFactorMap,
                         uint    *xNonFactorMap,
                         uint    *rNonFactorIndex,
                         uint    *xNonFactorIndex,
                         uint    **xLevels,
                         Factor ***factorList);
void initializeFactorArrays(char  mode,
                            uint  rFactorCount,
                            uint  xFactorCount,
                            uint *rFactorIndex,
                            uint *xFactorIndex,
                            uint *rLevelsMax,
                            uint *xLevelsMax,
                            uint *rLevelsCnt,
                            uint *xLevelsCnt,
                            uint  ntree,
                            uint  *rFactorSize,
                            uint  *xFactorSize,
                            uint  *rMaxFactorLevel,
                            uint  *xMaxFactorLevel,
                            uint  *maxFactorLevel,
                            Factor ****factorList);
char stackCompetingArrays(char     mode,
                          uint     statusIndex,
                          uint     splitRule,
                          uint     eventTypeSize,
                          uint    *eventType,
                          uint     crWeightSize,
                          double  *crWeight,
                          uint     frSize,
                          uint     observationSize,
                          uint     fobservationSize,
                          double **responseIn,
                          double **fresponseIn,
                          uint    *dmRecordMap,
                          uint    *fmRecordMap,
                          uint     dmRecordSize,
                          uint     fmRecordSize,
                          int    **dmpSign,
                          int    **fmpSign,
                          uint   **eventTypeIndex,
                          uint    *feventTypeSize,
                          uint    *mStatusSize,
                          uint   **eIndividualSize,
                          uint  ***eIndividualIn);
void getEventInfo(char     mode,
                  uint     statusIndex,
                  uint     observationSize,
                  uint     fobservationSize,
                  double **responseIn,
                  double **fresponseIn,
                  uint     eventTypeSize,
                  uint    *eventType,
                  uint    *dmRecordMap,
                  uint    *fmRecordMap,
                  uint     dmRecordSize,
                  uint     fmRecordSize,
                  int    **dmpSign,
                  int    **fmpSign,
                  uint    *mStatusSize,
                  uint    *feventTypeSize);
void unstackCompetingArrays(char   mode,
                            uint   statusIndex,
                            uint   eventTypeSize,
                            uint  *eventType,
                            uint   feventTypeSize,
                            uint  *eventTypeIndex,
                            uint   mStatusSize,
                            uint  *eIndividualSize,
                            uint **eIndividualIn);
char stackClassificationArrays(char     mode,
                               uint    *rFactorSize,
                               uint    *rLevelsCnt,
                               uint     rFactorCount,
                               uint     observationSize,
                               double **responseIn,
                               uint    *rFactorIndex,
                               uint     frSize,
                               double **fresponseIn,
                               uint     fobservationSize,
                               uint  ***rLevels,
                               uint   **classLevelSize,
                               uint  ***classLevel,
                               uint  ***classLevelIndex,
                               double **rFactorThreshold,
                               uint   **rFactorMinority,
                               uint   **rFactorMajority,
                               char   **rFactorMinorityFlag);
void unstackClassificationArrays(char    mode,
                                 uint   *rFactorSize,
                                 uint    rFactorCount,
                                 uint  **rLevels,
                                 uint   *classLevelSize,
                                 uint  **classLevel,
                                 uint  **classLevelIndex,
                                 double *rFactorThreshold,
                                 uint   *rFactorMinority,
                                 uint   *rFactorMajority,
                                 char   *rFactorMinorityFlag);
void stackFactorInSitu(uint  treeID,
                       uint  rFactorCount,
                       uint  xFactorCount,
                       uint  maxFactorLevel,
                       uint *rFactorSize,
                       uint *xFactorSize,
                       Factor ***factorList);
void unstackFactorInSitu(uint  treeID,
                         uint  rFactorCount,
                         uint  xFactorCount,
                         uint  maxFactorLevel,
                         Factor ***factorList);
#endif
