% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis-expect.R
\name{expect_frame}
\alias{expect_frame}
\title{Create a dataframe to help visualise 'expected' values}
\usage{
expect_frame(data, expectation)
}
\arguments{
\item{data}{data.frame}

\item{expectation}{unquoted conditions or "expectations" to test}
}
\value{
data.frames where expectation are true
}
\description{
Create a dataframe to help visualise 'expected' values
}
\examples{

\dontrun{
dat_test <- tibble::tribble(
            ~x, ~y,
            -1,  "A",
            0,  "B",
            1,  "C"
            )

expect_frame(dat_test,
             ~ .x == -1)
}
}
\author{
Stuart Lee and Earo Wang
}
