% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcacontour.R
\name{mcacontour}
\alias{mcacontour}
\title{Contour plots and MCA function for classification modeling}
\usage{
mcacontour(dataf=dataf,listconti,listclass,vardep,proba="",bins=8,
Dime1="Dim.1",Dime2="Dim.2",classvar=1,intergrid=0,selec=0,
title="",title2="",listacol="",depcol="",alpha1=0.8,alpha2=0.8,alpha3=0.7,modelo="glm",
nodos=3,maxit=200,decay=0.01,sampsize=400,mtry=2,nodesize=5,
ntree=400,ntreegbm=500,shrink=0.01,bag.fraction=1,n.minobsinnode=10,C=100,gamma=10)
}
\arguments{
\item{dataf}{data frame.}

\item{listconti}{Interval variables to use, in format c("var1","var2",...).}

\item{listclass}{Class variables to use, in format c("var1","var2",...).}

\item{vardep}{Dependent binary classification variable.}

\item{proba}{vector of probability predictions obtained externally (optional)}

\item{bins}{Number of bins for categorize interval variables .}

\item{Dime1}{FAMD Dimensions to consider. Dim.1 and Dim.2 by default.}

\item{Dime2}{FAMD Dimensions to consider. Dim.1 and Dim.2 by default.}

\item{classvar}{1 if dependent variable categories are plotted as supplementary}

\item{intergrid}{scale of grid for contour:0 if automatic}

\item{selec}{1 if stepwise logistic variable selection is required, 0 if not.}

\item{title}{plot main title}

\item{title2}{plot subtitle}

\item{listacol}{vector of colors for labels}

\item{depcol}{vector of two colors for points}

\item{alpha1}{alpha transparency for majoritary class}

\item{alpha2}{alpha transparency for minoritary class}

\item{alpha3}{alpha transparency for fit probability plots}

\item{modelo}{name of model: "glm","gbm","rf,","nnet","svm".}

\item{nodos}{nnet: nodes}

\item{maxit}{nnet: iterations}

\item{decay}{nnet: decay}

\item{sampsize}{rf: sampsize}

\item{mtry}{rf: mtry}

\item{nodesize}{rf: nodesize}

\item{ntree}{rf: ntree}

\item{ntreegbm}{gbm: ntree}

\item{shrink}{gbm: shrink}

\item{bag.fraction}{gbm: bag.fraction}

\item{n.minobsinnode}{gbm:n.minobsinnode}

\item{C}{svm Radial: C}

\item{gamma}{svm Radial: gamma}
}
\value{
A list with the following objects:\describe{
\item{graph1}{plot of points on MCA  two dimensions}
\item{graph2}{plot of points and variables}
\item{graph3}{plot of points and contour curves}
\item{graph4}{plot of points, contour curves and variables}
\item{graph5}{plot of points colored by fitted probability}
\item{graph6}{plot of points colored by abs difference}
\item{df1}{ dataset used for graph1}
\item{df2}{ dataset used for graph2}
\item{df3}{ dataset used for graph3}
\item{df4}{ dataset used for graph4}
\item{listconti}{ interval variables used}
\item{listclass}{ class variables used}
\item{...}{color schemes and other parameters }
}
}
\description{
This function presents visual graphics by means of Multiple correspondence Analysis projection.
Interval variables are categorized to bins.
Dependent classification variable is set as supplementary variable.
Machine learning algorithm predictions are presented in a filled contour setting.
}
\details{
This function applies MCA (Multiple Correspondence Analysis) in order to project points and categories of
class variables in the same plot. In addition, interval variables listed in listconti are categorized to
the number given in bins parameter (by default 8 bins). Further explanation about machine learning classification
and contour curves, see the famdcontour function documentation.
}
\examples{
data(breastwisconsin1)
dataf<-breastwisconsin1
listconti=c( "clump_thickness","uniformity_of_cell_shape","mitosis")
listclass=c("")
vardep="classes"
result<-mcacontour(dataf=dataf,listconti,listclass,vardep)
}
\keyword{MCA}
\keyword{classification}
\keyword{contour_curves}
