% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_conversation.R
\name{create_conversation}
\alias{create_conversation}
\title{Creates a new conversation with one or more recipients.}
\usage{
create_conversation(
  canvas,
  recipients = NULL,
  subject = " ",
  body = " ",
  force_new = TRUE,
  group_conversation = FALSE,
  attachments = NULL,
  attachment_ids = NULL,
  media_comment_id = NULL,
  media_comment_type = NULL,
  mode = "sync",
  scope = NULL,
  filter = NULL,
  filter_mode = NULL,
  context_code = NULL
)
}
\arguments{
\item{canvas}{An object containing the Canvas API key and base URL,}

\item{recipients}{An array of recipient ids.}

\item{subject}{The subject of the conversation. Maximum length is 255 characters.}

\item{body}{The message to be sent. Unfortunately, Canvas only allows for plain text.}

\item{force_new}{logical. Forces a new message to be created, even if there is an
existing private conversation.}

\item{group_conversation}{logical. Defaults to \code{FALSE}. When false, individual private
conversations will be created with each recipient. If true, this will be a group
conversation (i.e. all recipients may see all messages and replies). Must be set true
if the number of recipients is over the set maximum (default is 100).}

\item{attachments}{An array of paths to local files that should be uploaded.}

\item{attachment_ids}{An array of attachments ids. These must be files that have been previously
uploaded to the sender's 'conversation attachments' folder.}

\item{media_comment_id}{Media comment id of an audio or video file to be associated with this
message.}

\item{media_comment_type}{Type of the associated media file, values allowed are \code{audio} or
\code{video}.}

\item{mode}{Determines whether the messages will be created/sent synchronously or
asynchronously. Defaults to \code{sync}.}

\item{scope}{Used when generating 'visible' in the API response, values allowed are \code{unread},
\code{starred}, \code{archived}.}

\item{filter}{Used when generating 'visible' in the API response.}

\item{filter_mode}{Used when generating 'visible' in the API response, values allowed are \code{and}, \code{or}
(default).}

\item{context_code}{The course or group that is the context for this conversation. Same format
as courses or groups in the recipients argument.}
}
\value{
A confirmation message indicating that the message has been successfully send.
}
\description{
Canvas allows for an e-mail like communication with students, called 'conversations', which can
be handled
from the API.
}
\details{
Note that the user should have rights to access the folder.
}
\seealso{
\code{\link[=get_single_conversation]{get_single_conversation()}} and \code{\link[=get_conversations]{get_conversations()}}.
}
