% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edit_section.R
\name{edit_section}
\alias{edit_section}
\title{Edit a Course Section in Canvas LMS}
\usage{
edit_section(
  canvas,
  section_id,
  section_name = NULL,
  sis_section_id = NULL,
  integration_id = NULL,
  section_start_date = NULL,
  section_end_date = NULL,
  restrict_enrollments_to_section_dates = NULL,
  override_sis_stickiness = NULL
)
}
\arguments{
\item{canvas}{A list containing the 'api_key' and 'base_url' for authentication.}

\item{section_id}{The ID of the section to edit.}

\item{section_name}{The new name of the section (optional).}

\item{sis_section_id}{The new SIS ID of the section (optional).}

\item{integration_id}{The new integration ID of the section (optional).}

\item{section_start_date}{The new start date of the section (optional).}

\item{section_end_date}{The new end date of the section (optional).}

\item{restrict_enrollments_to_section_dates}{Whether to restrict user enrollments to the start and end dates of the section (optional).}

\item{override_sis_stickiness}{Whether to override SIS stickiness (optional).}
}
\value{
A confirmation message that the section has been edited.
}
\description{
Modifies an existing course section using the Canvas LMS API.
}
