% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server_prep.R
\name{prep_df_summ_aggr}
\alias{prep_df_summ_aggr}
\title{Prepare summarized and aggregated dataframe}
\usage{
prep_df_summ_aggr(
  df,
  variables,
  y,
  color,
  total_n_var = rlang::sym("INS_Aantal_eerstejaars"),
  aggr_split_value_var = rlang::sym("INS_Splits_variabele_waarde")
)
}
\arguments{
\item{df}{A dataframe to be summarized}

\item{variables}{A character vector specifying the columns to be grouped by}

\item{y}{A character vector specifying the column to be summarized}

\item{color}{A character vector specifying the column to be used for color arrangement}

\item{total_n_var}{A symbol specifying the variable to be used for total count calculation}

\item{aggr_split_value_var}{A symbol specifying the variable to be used for color assignment}
}
\value{
A summarized and aggregated dataframe arranged by color
}
\description{
This function prepares a summarized dataframe based on provided variables, y-variable,
color, and total count. The function groups the dataframe by the provided variables,
calculates the weighted mean for the y-variable, sums up total count per group, and arranges by color.
}
\examples{
df <- data.frame( split_var_value = c("male", "male", "female", "female", "dutch", "dutch",
"EER", "EER", "Outside EER", "Outside EER"), other_var = c("Early", "Late", "Early", "Late",
"Early", "Late", "Early", "Late", "Early", "Late"), value = c(2, 4, 6, 8, 10, 2, 4, 6, 8, 10),
total = c(10, 10, 20, 20, 30, 30, 40, 40, 50, 50), split_var = c("gender", "gender", "gender",
"gender", "background", "background", "background", "background", "background", "background") )
}
