% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{m_Pageviews}
\alias{m_Pageviews}
\title{Get number of views of a Wikipedia article}
\usage{
m_Pageviews(
  article,
  start,
  end,
  project = "en.wikipedia.org",
  access = "all-access",
  agent = "user",
  granularity = "monthly",
  redirects = FALSE
)
}
\arguments{
\item{article}{The title of the article to search. Only one article is allowed.}

\item{start, end}{First and last day to include (format YYYYMMDD or YYYYMMDDHH)}

\item{project}{The Wikimedia project, defaults en.wikipedia.org}

\item{access}{Filter by access method: all-access (default), desktop, mobile-app, mobile-web}

\item{agent}{Filter by agent type: all-agents, user (default), spider, automated}

\item{granularity}{Time unit for the response data: daily, monthly (default)}

\item{redirects}{Boolean to include the views of all redirections of the page
(defaults: False). If redirects=TRUE then the "normalized" element of the
returned vector contains the destiny of the redirection, and the "original"
element contains the original title of the article.
If a page is just a destiny of other pages, and you want to know the total
number of views that page have (including views of redirections), it is also
necessary set redirects=TRUE,  otherwise only you have the views of that page.}
}
\value{
A vector with the number of visits by granularity.
}
\description{
Use the Wikimedia REST API (https://wikimedia.org/api/rest_v1/) to get the
number of views one article has in a Wikimedia project in a date interval
(see granularity). If redirect=TRUE, then get the number of views of all
articles that redirects to the article which is the destiny of actual page.
}
\examples{
v <-  m_Pageviews(article="Cervantes", start="20230101", end="20230501",
                   project="es.wikipedia.org", granularity="monthly")
vv <- m_Pageviews(article="Cervantes", start="20230101", end="20230501",
                   project="es.wikipedia.org", granularity="monthly",
                   redirects=TRUE)
}
\author{
Angel Zazo, Department of Computer Science and Automatics, University of Salamanca
}
