% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imageW.R
\name{imageW}
\alias{imageW}
\title{Display numeric content of matrix as image}
\usage{
imageW(
  dat,
  col = NULL,
  rowNa = NULL,
  colNa = NULL,
  tit = NULL,
  cexXlab = 0.7,
  cexAxs = NULL,
  cexYlab = 1,
  cexTit = 1.6,
  NAcol = grDevices::grey(0.8),
  las = 2
)
}
\arguments{
\item{dat}{(list) main input}

\item{col}{(character or integer) colors, default is heat.colors in 15 shades}

\item{rowNa}{(character) optional custom rownames}

\item{colNa}{(character) optional custom colnames}

\item{tit}{(character) custom figure title}

\item{cexXlab}{(numeric) cex-like expansion factor for x-axis labels  (see also \code{\link[graphics]{par}})}

\item{cexAxs}{(numeric) cex-like expansion factor for x- and y-axis text/labels (see also \code{\link[graphics]{par}})}

\item{cexYlab}{(numeric) cex-like expansion factor for y-axis labels  (see also \code{\link[graphics]{par}})}

\item{cexTit}{(numeric) cex-like expansion factor for title  (see also \code{\link[graphics]{par}})}

\item{NAcol}{(character or integer) custom color fro NA-values, default is grey}

\item{las}{(numeric) style of axis labels (see also \code{\link[graphics]{par}})}
}
\value{
graphical output only
}
\description{
To get a quick overview of the distribution of data and, in particular, of local phenomena it is useful to express numeric values as colored boxes.
Such an output can be referred to as heatmap.
The function \code{\link[graphics]{image}} provides the basic support to do so.  
To do this more conveniently, the function \code{imageW} offers additional options for displaying row- and column-names or displaying NA-values as custom-color.
}
\examples{
imageW(as.matrix(iris[1:40,1:4]))
}
\seealso{
\code{\link[graphics]{image}}, heatmaps including hierarchical clustering \code{\link[stats]{heatmap}} or \code{heatmap.2} from  \href{https://CRAN.R-project.org/package=gplots}{gplots}
}
