% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPCAw.R
\name{.addTextToPoints}
\alias{.addTextToPoints}
\title{Add text to points on plot}
\usage{
.addTextToPoints(
  x,
  paramLst = NULL,
  labels = NULL,
  cex = NULL,
  col = NULL,
  adj = "auto",
  callFrom = NULL,
  silent = TRUE,
  debug = FALSE
)
}
\arguments{
\item{x}{(matrix, data.frame) coordinated of ponts on plot}

\item{paramLst}{(list) additional parameters for plotting (priority over separate cex or col), otherwise names displayed will be taken from 'labels' or rownames of coordinates 'x'}

\item{labels}{(character) the text to be displayed (has not priority over 'paramLst'), if nothing valid found numbers will be displayed}

\item{cex}{(character) (numeric) size of text, as expansion factor (see also \code{cex} in \code{\link[graphics]{par}})}

\item{col}{(character or integer) use custom colors}

\item{adj}{(character) values other than 0,0.5 or 1 will lead to 'auto' where text is displayed only to left of sufficient space available}

\item{callFrom}{(character) allow easier tracking of messages produced}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) display additional messages for debugging}
}
\value{
This function make a plot and may retiurn an optional matrix of outlyer-data (depending on argument \code{getOutL})
}
\description{
This function allows to add custom text as lables to points on standard xy-plot.
}
\examples{
set.seed(2019); dat1 <- matrix(round(runif(30),2), ncol=2)
plot(dat1)        # traditional plot
.addTextToPoints(dat1, labels=letters[1:nrow(dat1)])
}
\seealso{
\code{\link[stats]{prcomp}} (used here for the PCA underneith) , \code{\link[stats]{princomp}}, see the package \href{https://CRAN.R-project.org/package=FactoMineR}{FactoMineR} for multiple plotting options or ways of combining categorical and numeric data
}
