% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/staggerdCountsPlot.R
\name{staggerdCountsPlot}
\alias{staggerdCountsPlot}
\title{Staggered Chart for Ploting Counts to Multiple Leveles of the Threshold used}
\usage{
staggerdCountsPlot(
  roc,
  threColumn = 1,
  countsCol = NULL,
  fixedCountPat = "n.pos.",
  varCountNa = NULL,
  sortAscending = TRUE,
  vertLine = NULL,
  col = NULL,
  tit = NULL,
  logScale = FALSE,
  las.alph = 2,
  displMaxSpec = TRUE,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{roc}{(numeric matrix or data.frame) main input: one column with thresholds and multiple columns of assoicated count data}

\item{threColumn}{(integer or character) to specify the column with threshold-data, in typica proteomics benchmark studies this would be 'alph' (for the statistical test threshold)}

\item{countsCol}{(character of integer, min length=2) choice of column(s) with count-data in 'roc' to be used for display, if not \code{NULL} will override alternative search of columns using 'varCountNa' and 'fixedCountPat'}

\item{fixedCountPat}{(character) optional pattern to help identifying counts-data: if not \code{NULL} it will be used as fixed part in column names to get pasted to \code{varCountNa}.
In proteomics benchmark studies this would typically be 'n.pos.'}

\item{varCountNa}{(character) alternative way to select the columns from 'roc': searched using \code{\link[base]{grep}} using column-names containing the text given in argument \code{varCountNa} with may be combined with a fixed preceeding part given as argument \code{fixedCountPat}
In proteomics benchmark studies this would typically be the species-abbreciations (eg 'H','S','E')}

\item{sortAscending}{(logical) decide if data should be sorted ascending or descending}

\item{vertLine}{(numeric) for optional vertical line, typically used to highlight alpha 0.05}

\item{col}{(character) custom colors, see also \code{\link[graphics]{par}}}

\item{tit}{(character) cutom title}

\item{logScale}{(logical) display threshld values (x-axis) on log-scale}

\item{las.alph}{(numeric) orientation of label of alpha-cutoff, see also \code{\link[graphics]{par}}}

\item{displMaxSpec}{(logical) display on right side of figure max count value of contributing group species}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additonal messages for debugging}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
plot only
}
\description{
The basic idea of this plot is to show how counts data change while shifting a threshold-criterium.
At each given threshold the counts are plotted like a staggered bar-chart (or staggered histogram) but without vertical lines to illustrated the almost continuous change
from preceedig or following threshold-value.
Initially this plot was designed for showing the absolute count-data used when constructing roc-curves (eg using 
the function \code{summarizeForROC} of package \href{https://CRAN.R-project.org/package=wrProteo}{wrProteo} ).
The main input should furnish the panel of threshold as one column and the coresponding counts data as min 2 columns. 
The threshold coumns gets specified using the argument \code{threColumn}, the counts-data may either be specified using argument \code{countsCol}
or be searched using \code{\link[base]{grep}} using column-names containing the text given in argument \code{varCountNa} with may be combined with 
a fixed preceeding part given as argument \code{fixedCountPat}.
}
\details{
Investigate count data prepared for plotting ROC curves : cumulative counts plot by species (along different statistical test thresholds).
Note : Package \href{https://CRAN.R-project.org/package=wrProteo}{wrProteo} may be used to prepare input (matrix of ROC data).
}
\examples{
set.seed(2019); test1 <- cbind(a=sample.int(n=7,size=50,repl=TRUE),
  b=sample.int(n=11,size=50,repl=TRUE),c=sample.int(n=18,size=50,repl=TRUE))
test1 <- cbind(alph=seq(0,1,length.out=50),a=cumsum(test1[,1]),b=cumsum(test1[,2]),
  c=cumsum(test1[,3]))
staggerdCountsPlot(test1,countsCol=c("a","b","c"))
## example below requires the package wrProteo
}
\seealso{
\code{\link[stats]{ecdf}}, for preparing input to ROC: function \code{summarizeForROC} in package \href{https://CRAN.R-project.org/package=wrProteo}{wrProteo}
}
