% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_wider.R
\name{make_wider}
\alias{make_wider}
\title{Pivot a table wider combining counts and percentages}
\usage{
make_wider(x, top_variable = NULL, names_prefix = "")
}
\arguments{
\item{x}{A data frame or tibble containing at least the columns \code{N} and \code{Percent}.
Typically the output of \link{build_table}, \link{build_mtable}, or \link{build_qtable},.}

\item{top_variable}{Optional. A bare column name to use for the \code{names_from} argument
in \code{pivot_wider}. If \code{NULL} (default), the function infers the column
based the default position.}

\item{names_prefix}{String added to the start of every variable name. This is
particularly useful if \code{top_variable} is a numeric vector and you want to create
syntactic variable names.}
}
\value{
A \link{xlr_table} (if x is a \link{xlr_table}) or \link[tibble:tibble]{tibble::tibble} (if \link[tibble:tibble]{tibble::tibble} or
\code{data.frame}) in a wider format with columns containing
\code{xlr_n_percent} vectors.
}
\description{
This function takes a data frame produced by functions like \link{build_table},
\link{build_mtable}, or \link{build_qtable}, which contains columns \code{N} and \code{Percent},
and pivots it into a wider format. It combines the \code{N} and \code{Percent} columns into
a single \link{xlr_n_percent} vector for each pivoted column. If \code{top_variable} is not
specified, it infers the variable to use for column names from the structure of the data frame.
}
\examples{
library(xlr)
# Assuming example data from build_table or similar
table <- clothes_opinions |>
            build_table(c(gender,age_group))
make_wider(table)

# use top_variable to specify that we have gender as out selection column
make_wider(table, top_variable = age_group)

}
\seealso{
\code{\link{xlr_n_percent}}, \code{\link[tidyr]{pivot_wider}}
}
