% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtdml_data.R
\name{xtdml_data}
\alias{xtdml_data}
\title{Data-backed DML Environment}
\description{
Data-backed environment for Double machine learning (DML) that cannot be initialized.
\code{xtdml_data} sets up the data environment for panel data analysis with transformed variables.
The \code{\link[=xtdml_data_from_data_frame]{xtdml_data_from_data_frame()}} function can be used to create a new
instance of \code{xtdml_data} from a \code{data.frame}.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{all_variables}}{(\code{character()})\cr
All variables available in the data frame.}

\item{\code{d_cols}}{(\code{character()})\cr
The treatment variable.}

\item{\code{dbar_col}}{(\code{NULL}, character()`)\cr
The individual mean of the treatment variable.}

\item{\code{data}}{(\code{\link[data.table:data.table]{data.table}})\cr
Data object.}

\item{\code{data_model}}{(\code{\link[data.table:data.table]{data.table}})\cr
Internal data object that implements the causal panel model as specified by
the user via \code{y_col}, \code{d_cols}, \code{x_cols}, \code{dbar_col}.}

\item{\code{n_obs}}{(\code{integer(1)}) \cr
The number of observations.}

\item{\code{n_treat}}{(\code{integer(1)}) \cr
The number of treatment variables.}

\item{\code{treat_col}}{(\code{character(1)}) \cr
"Active" treatment variable in the multiple-treatment case.}

\item{\code{x_cols}}{(\code{character()}) \cr
The covariates.}

\item{\code{y_col}}{(\code{character(1)}) \cr
The outcome variable.}

\item{\code{panel_id}}{(\code{character()})\cr
The panel identifier.}

\item{\code{time_id}}{(\code{character()})\cr
The time identifier.}

\item{\code{cluster_cols}}{(\code{character()})\cr
The cluster variable(s).}

\item{\code{n_cluster_vars}}{(\code{integer(1)}) \cr
The number of cluster variables.}

\item{\code{approach}}{(\code{character(1)}) \cr
A \code{character()} (\code{"fd-exact"}, \code{"wg-approx"} or \code{"cre"}) specifying the panel data
technique to apply to estimate the causal model. Default is \code{"fd-exact"}.}

\item{\code{transformX}}{(\code{character(1)}) \cr
A \code{character()} (\code{"no"}, \code{"minmax"} or \code{"poly"}) specifying the type
of transformation to apply to the X data. \code{"no"} does not transform the covariates \code{X}
and is recommended for tree-based learners. \code{"minmax"} applies the Min-Max normalization
\eqn{x' = (x-x_{min})/(x_{max}-x_{min})} to the covariates and is recommended with neural networks.
\code{"poly"} add polynomials up to order three and interactions between all possible
combinations of two and three variables; this is recommended for Lasso. Default is \code{"no"}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-xtdml_data-new}{\code{xtdml_data$new()}}
\item \href{#method-xtdml_data-print}{\code{xtdml_data$print()}}
\item \href{#method-xtdml_data-plot}{\code{xtdml_data$plot()}}
\item \href{#method-xtdml_data-set_data_model}{\code{xtdml_data$set_data_model()}}
\item \href{#method-xtdml_data-clone}{\code{xtdml_data$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-xtdml_data-new"></a>}}
\if{latex}{\out{\hypertarget{method-xtdml_data-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{xtdml_data$new(
  data = NULL,
  x_cols = NULL,
  y_col = NULL,
  d_cols = NULL,
  dbar_col = NULL,
  panel_id = NULL,
  time_id = NULL,
  cluster_cols = NULL,
  approach = NULL,
  transformX = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{(\code{\link[data.table:data.table]{data.table}}, \code{data.frame()})\cr
Data object.}

\item{\code{x_cols}}{(\code{character()}) \cr}

\item{\code{y_col}}{(\code{character(1)}) \cr
The outcome variable.}

\item{\code{d_cols}}{(\code{character(1)}) \cr
The treatment variable.}

\item{\code{dbar_col}}{(\code{NULL}, character()\verb{) \\cr Individual mean of the treatment variable (used for the CRE approach). Default is }NULL`.}

\item{\code{panel_id}}{(\code{character()}) \cr
The panel identifier.}

\item{\code{time_id}}{(\code{character()}) \cr
The time identifier.}

\item{\code{cluster_cols}}{(\code{character()}) \cr
The cluster variable(s).}

\item{\code{approach}}{(\code{character(1)}) \cr
A \code{character()} (\code{"fd-exact"}, \code{"wg-approx"} or \code{"cre"})
specifying the panel data technique to apply
to estimate the causal model. Default is \code{"fd-exact"}.}

\item{\code{transformX}}{(\code{character(1)}) \cr
A \code{character()} (\code{"no"}, \code{"minmax"} or \code{"poly"}) specifying the type
of transformation to apply to the X data. \code{"no"} does not transform the covariates \code{X}
and is recommended for tree-based learners. \code{"minmax"} applies the Min-Max normalization
\eqn{x' = (x-x_{min})/(x_{max}-x_{min})} to the covariates and is recommended with neural networks.
\code{"poly"} add polynomials up to order three and interactions between all possible
combinations of two and three variables; this is recommended for Lasso.
Default is \code{"no"}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-xtdml_data-print"></a>}}
\if{latex}{\out{\hypertarget{method-xtdml_data-print}{}}}
\subsection{Method \code{print()}}{
Print \code{xtdml_data} objects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{xtdml_data$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-xtdml_data-plot"></a>}}
\if{latex}{\out{\hypertarget{method-xtdml_data-plot}{}}}
\subsection{Method \code{plot()}}{
Plotting method, which is not implemented for \code{xtdml} objects.

Attempting to call it returns an informative message.
Use the \code{print()} method to view \code{xtdml_data} objects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{xtdml_data$plot()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-xtdml_data-set_data_model"></a>}}
\if{latex}{\out{\hypertarget{method-xtdml_data-set_data_model}{}}}
\subsection{Method \code{set_data_model()}}{
Setter function for \code{data_model}.

The function implements the causal model
as specified by the user via \code{y_col}, \code{d_cols}, \code{x_cols}, \code{panel_id}, \code{time_id} and
\code{cluster_cols} and assigns the role for the treatment variables in the
multiple-treatment case.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{xtdml_data$set_data_model(treatment_var)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{treatment_var}}{(\code{character()})\cr
Active treatment variable that will be set to \code{treat_col}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-xtdml_data-clone"></a>}}
\if{latex}{\out{\hypertarget{method-xtdml_data-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{xtdml_data$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
