% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{list_options}
\alias{list_options}
\title{List package options}
\usage{
list_options(
  as = c("list", "params", "markdown"),
  .envir = sys.function(which = -1)
)
}
\arguments{
\item{as}{\verb{[character(1)]} Format in which to return the options:
\itemize{
\item \code{"list"}: Return a nested list, where each top level element is a list with
the specification of an option.
\item \code{"params"}: Return a character vector with the \code{"@param"} tag entries for
each option similar to how function parameters are documented with roxygen2.
\item \code{"markdown"}: Return a character string with markdown formatted entries for
each option.
}}

\item{.envir}{Environment in which the options are defined.
Default is suitable for use inside your package.}
}
\value{
\code{list} or \code{character} depending on \code{as}
}
\description{
List all \code{zephyr_options} specified in a package. Either as an \code{list} or as
as \code{character} vector formatted for use in your package documentation.

To document your options use \code{\link[=use_zephyr]{use_zephyr()}} to set everything up, and edit
the created template as necessary.
}
\examples{
# List all options in zephyr
x <- list_options(.envir = "zephyr")
print(x)
str(x)

# Create @params tag entries for each option
list_options(as = "params", .envir = "zephyr") |>
  cat()

# List options in markdown format
list_options(as = "markdown", .envir = "zephyr") |>
  cat()
}
