#' FFT Matrix Shift
#'
#' This function rearranges the output of a 2D FFT by moving the
#' zero-frequency component to the center of the matrix. It is used
#' internally by \code{AcuityView()} to correctly align spatial frequencies.
#'
#' @param input_matrix The output of a 2D FFT.
#' @param dim Integer. \code{-1} gives the correct matrix shift for the
#'   AcuityView function.
#'
#' @return A matrix with the zero-frequency component shifted to the center.
#'
#' @keywords internal
fft_matrix_shift <- function(input_matrix, dim = -1) {
  
  if (!is.matrix(input_matrix)) {
    stop("input_matrix must be a matrix")
  }
  
  nr <- nrow(input_matrix)
  nc <- ncol(input_matrix)
  
  rshift <- floor(nr / 2)
  cshift <- floor(nc / 2)
  
  shifted <- input_matrix[
    c((rshift + 1):nr, 1:rshift),
    c((cshift + 1):nc, 1:cshift)
  ]
  
  return(shifted)
}
