% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_rwl.R
\name{import_rwl}
\alias{import_rwl}
\title{import_rwl}
\usage{
import_rwl(
  rwl_path,
  po_path,
  ageBands,
  first_age_class = NULL,
  zero_as_na = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{rwl_path}{Path to the RWL file (Tucson format).}

\item{po_path}{Path to the pith offset file (tab-delimited text file with columns
'tree_code' and 'pith.offset').}

\item{ageBands}{character. Setting the age band window. It must be set to '1010' if all the
age classes have the same size (10 years). It must be '1020' if the age classes
have different sizes: 10 years till 100 and then 20 years size.}

\item{first_age_class}{numeric. is numeric and specifies the first age band from which the analysis begins.
If NULL (default),
no filtering is applied. For example, first_age_class = 3 excludes the first
20 years of growth (age classes 1 and 2 in '1010' mode).}

\item{zero_as_na}{logical. If TRUE (default), zero values in TRW are converted to NA.
If FALSE, zero values are kept as is.}

\item{verbose}{logical. If TRUE, prints additional information during import.}
}
\value{
A list of two objects. The first object is a tibble representing the
imported dataset in long format. In this tibble the last two columns are
an identification number (id_by_years) and two grouping variables (age_class and ageBands).
The second object in the list is a lookup table (tibble), useful for further steps.
}
\description{
This function imports tree-ring width data from RWL (Tucson format) files
and pith offset information, then arranges the dataset for ABD analysis.
}
\details{
The RWL file must be in Tucson format (readable by dplR::read.rwl).
The pith offset file must be a tab-delimited text file with header containing
columns 'tree_code' and 'pith.offset', where pith.offset indicates the number
of missing rings between the pith and the first measured ring.
are available on the package's GitLab page.
\url{https://gitlab.com/Puletti/agebanddecomposition_rpackage}
and can be used to test the package's functions.
}
\examples{
# Download example files from the package's GitLab page
package_gitlab_site <- 'https://gitlab.com/Puletti/agebanddecomposition_rpackage'
rwl_url <- "/-/raw/main/studio/dati/TRW_example.rwl"
po_url <- "/-/raw/main/studio/dati/pith.offset.txt"

# Create temporary files
tmpfile_rwl <- tempfile(fileext = ".rwl")
tmpfile_po <- tempfile(fileext = ".txt")

# Download the files
download.file(paste0(package_gitlab_site, rwl_url),
              tmpfile_rwl,
              mode = "wb")

download.file(paste0(package_gitlab_site, po_url),
              tmpfile_po,
              mode = "wb")

# Import the data
inData <- import_rwl(rwl_path = tmpfile_rwl, 
                             po_path = tmpfile_po, 
                             ageBands = '1010', 
                             first_age_class = 3,
                             zero_as_na = TRUE,
                             verbose = TRUE)

# View the result
inData
}
\seealso{
\code{\link{stdTRW}}, \code{\link{ABD}}

Other ABD functions: 
\code{\link{ABD}()},
\code{\link{stdTRW}()}
}
\concept{ABD functions}
