% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.r
\name{rawToAmigaBasicShape}
\alias{rawToAmigaBasicShape}
\title{Coerce raw data into an AmigaBasicShape class object}
\usage{
rawToAmigaBasicShape(x, palette)
}
\arguments{
\item{x}{A \code{vector} of \code{raw} data that is to be converted
into an \code{\link[=AmigaBasicShape]{AmigaBasicShape()}} class object.}

\item{palette}{A \code{vector} of \code{character} strings, where each element represents a colour in the palette.
This palette will be used to display the graphics (note that the raw format does not store the palette, but this
S3 class does). When this argument is omitted a grey scale palette will be generated.}
}
\value{
returns an \code{\link[=AmigaBasicShape]{AmigaBasicShape()}}-class object.
}
\description{
Coerce raw data into an \code{\link[=AmigaBasicShape]{AmigaBasicShape()}}-class object
}
\details{
\code{\link[=AmigaBasicShape]{AmigaBasicShape()}} objects are comprehensive representations of blitter
and sprite graphics that can be used in \code{\link[=AmigaBasic]{AmigaBasic()}} scripts. Use this function
to convert \code{raw} content to an \code{\link[=AmigaBasicShape]{AmigaBasicShape()}} object.
}
\examples{
filename <- system.file("ball.shp", package = "AmigaFFH")

## read as binary:
con      <- file(filename, "rb")
ball.raw <- readBin(con, "raw", file.size(filename))
close(con)

## convert raw data into something useful:
ball     <- rawToAmigaBasicShape(ball.raw)

## A shortcut would be to call read.AmigaBasicShape
ball2    <- read.AmigaBasicShape(filename)
}
\seealso{
Other raw.operations: 
\code{\link{as.AmigaBasic}()},
\code{\link{as.raw.AmigaBasic}()},
\code{\link{colourToAmigaRaw}()},
\code{\link{packBitmap}()},
\code{\link{rawToAmigaBasic}()},
\code{\link{rawToAmigaBasicBMAP}()},
\code{\link{rawToAmigaBitmapFont}()},
\code{\link{rawToAmigaBitmapFontSet}()},
\code{\link{rawToAmigaIcon}()},
\code{\link{rawToHWSprite}()},
\code{\link{rawToIFFChunk}()},
\code{\link{rawToSysConfig}()},
\code{\link{simpleAmigaIcon}()}
}
\author{
Pepijn de Vries
}
\concept{AmigaBasicShapes.operations}
\concept{raw.operations}
