% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{amiga_monitors}
\alias{amiga_monitors}
\title{A list om Amiga monitors}
\format{a \code{data.frame} with 2 columns:
\itemize{
  \item{The column named `MONITOR_ID': a \code{factor} representing an Amiga monitor}
  \item{The column named `CODE': A \code{list} containing a \code{vector} of 4
  \code{raw} values as used by the Amiga to represent a specific monitor.}
}}
\description{
This table lists Amiga monitors and corresponding \code{raw} codes that represent
these monitors.
}
\details{
This table contains monitors that were compatible with the Amiga.
It also contains \code{raw} codes that were used to represent them.
This data is used to interpret \code{\link{IFFChunk}} objects of type
`CAMG'. It is also used to interpret ILBM images and creating IFF files from
raster images.
}
\examples{
data("amiga_monitors")
}
\references{
\url{http://wiki.amigaos.net/wiki/Display_Database#ModeID_Identifiers}
}
