% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iff.0.r
\name{read.iff}
\alias{read.iff}
\title{Read Interchange File Format (IFF)}
\usage{
read.iff(file)
}
\arguments{
\item{file}{A filename of an IFF file to be read, or a connection from which
binary data can be read.}
}
\value{
Returns a \code{\link{IFFChunk}} object read from the specified file.
}
\description{
Read the Interchange File Format (IFF) as an \code{\link{IFFChunk}} object.
}
\details{
Information is stored as `chunks' in IFF files (see \code{\link{IFFChunk}}).
Each chunk should at least contain a lable of the type of chunk and the data
for that chunk. This function reads all chunks from a valid IFF file, including
all nested chunks and stores them in an \code{\link{IFFChunk}} object. IFF
files can hold any kind of data (e.g. images or audio), this read function
does not interpret the file. Use \code{\link{interpretIFFChunk}} for that
purpose.
}
\examples{
\dontrun{
## let's read a bitmap image stored in IFF as provided with this package:
filename <- system.file("ilbm8lores.iff", package = "AmigaFFH")
example.iff <- read.iff(filename)

## And plot it:
plot(example.iff)
}
}
\seealso{
Other io.operations: \code{\link{write.iff}}

Other iff.operations: \code{\link{IFFChunk-class}},
  \code{\link{WaveToIFF}}, \code{\link{as.raster}},
  \code{\link{as.raw}}, \code{\link{getIFFChunk}},
  \code{\link{interpretIFFChunk}},
  \code{\link{rasterToIFF}}, \code{\link{write.iff}}
}
\author{
Pepijn de Vries
}
