% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitmapfont.r
\docType{class}
\name{AmigaBitmapFont}
\alias{AmigaBitmapFont}
\alias{AmigaBitmapFontSet}
\title{The S3 AmigaBitmapFont and AmigaBitmapFontSet classes}
\description{
A comprehensive representation of monochromous Amiga bitmap fonts.
}
\details{
Nowadays fonts are represented by vector graphics an computer systems.
On the original Commodore Amiga, the screen resolution, system memory
and cpu speed were limited. On those systems, it was more efficient
to use bitmap images to represent the glyphs in fonts. The
\code{AmigaBitmapFontSet} and \code{AmigaBitmapFont} classes can be used
to represent Amiga bitmap fonts.

The Commodore Amiga had a directory named 'FONTS' located in the
root, where (bitmap) fonts were stored. Font sets where stored
under the font name with a *.font extension. Files with the *.font
extension did not contain the bitmap images of the font. Rather
the *.font file contained information on which font heights (in
pixels) are available, in addition to some other meta-information.

The bitmap images where stored in separate files for each individual
height. The \code{AmigaBitmapFontSet} is an S3 class that forms
a comprehensive format (named \code{list}) to represent the *.font
files. The \code{AmigaBitmapFont} is an S3 class is a comprehensive
format (named \code{list}) that represent each font bitmap and glyph
information. The \code{AmigaBitmapFontSet} objects will hold one or more
\code{AmigaBitmapFont} objects.

The \code{AmigaBitmapFont} and \code{AmigaBitmapFontSet} objects are
essentially named \code{list}s. Their structure and most important
elements are described below. Although it is possible to replace
elements manually, it is only advisable when you know what you
are doing as it may break the validity of the font.
}
\section{AmigaBitmapFontSet}{

\describe{
  \item{\code{fch_FileID}}{
    A \code{factor} with levels 'FontContents', 'TFontContents' and
    'ScalableOutline'. It specifies the type of font.
    Currently only the first level is supported.
  }
  \item{\code{fch_NumEntries}}{
    number of font heights available for this font. It should
    match with the length of \code{FontContents}. Do not change
    this value manually.
  }
  \item{\code{FontContents}}{
    This is a \code{list} with bitmap entries for each specific font
    height (in pixels). The name of each element in this list is
    'pt' followed by the height. Each element in this list holds
    the elements:
    \describe{
      \item{Miscellaneous}{Miscellaneous information from the *.font file}
      \item{\code{fc_FileName}}{
        This element represents the filename of the
        nested font bitmap images. Note that it should be a valid
        Commodore Amiga filename. It is best to modify this name
        using \code{\link{fontName}}. Note that this field could cause
        problems as Commodore Amiga filenames can contain characters
        that most modern platforms would not allow (such as the
        question mark).
      }
      \item{\code{BitmapFont}}{
        This element is of type \code{AmigaBitmapFont} and is structured
        as described in the following section. The information in this
        element is no longer part of the *.font file.
      }
    }
  }
}
}

\section{AmigaBitmapFont}{

Information represented by a \code{AmigaBitmapFont} is not stored
in *.font files. Rather it is stored in sub-directories of the font
in separate files. It has the following structure:
\describe{
  \item{Miscellaneous}{Elements with information on the font
  properties and style, and also relative file pointers.}
  \item{\code{glyph.info}}{
    A \code{data.frame} containing glyph info with information
    for specific glyphs on each row. Each row matches with a specific
    ASCII code, ranging from \code{tf_LoChar} up to \code{tf_HiChar}. There is an additional
    row that contains information for the default glyph that is
    out of the range of the \code{tf_LoChar} and \code{tf_HiChar}. The \code{data.frame}
    thus has \code{2 + tf_HiChar - tf_LoChar} rows. This
    table is used to extract and plot a glyph from the
    \code{bitmap} image correctly.
  }
  \item{\code{bitmap}}{
    Is a monochromous bitmap image of all the font's glyphs in a
    single line. It is a simple \code{raster} object
    (see \code{\link[grDevices]{as.raster}}) with an additional
    attribute 'palette', which lists the two colours in the image. In
    this palette, the first colour is the background colour and the
    second colour is interpreted as the foregroundcolour.
  }
}
}

\section{Useful functions}{

For importing and exporting the following functions are useful:
\code{\link{read.AmigaBitmapFont}}, \code{\link{read.AmigaBitmapFontSet}},
\code{\link{write.AmigaBitmapFont}} and \code{\link{write.AmigaBitmapFontSet}}.

The following generic functions are implemented for these objects:
\code{\link[AmigaFFH]{plot}}, \code{print},
\code{\link[AmigaFFH]{as.raster}} and \code{\link[AmigaFFH]{as.raw}}.

Use \code{\link[AmigaFFH]{c}} to combine one or more
\code{AmigaBitmapFont} objects into a \code{AmigaBitmapFontSet}.
}

\examples{
\dontrun{
## 'font_example' is an example of the AmigaBitmapFontSet object:
data(font_example)

## An AmigaBitmapFont object can also be extracted from this object:
font_example_9 <- getAmigaBitmapFont(font_example, 9)

## the objects can be printed, plotted, converted to raw data or a raster:
print(font_example)
plot(font_example)
font_example_raw    <- as.raw(font_example)
font_example_raster <- as.raster(font_example)

## You can also format text using the font:
formated_raster     <- as.raster(font_example, text = "Foo bar", style = "bold")
plot(font_example, text = "Foo bar", style = "underlined", interpolate = F)
}
}
\references{
\url{http://amigadev.elowar.com/read/ADCD_2.1/Libraries_Manual_guide/node03E0.html}
\url{http://amigadev.elowar.com/read/ADCD_2.1/Libraries_Manual_guide/node03DE.html}
\url{http://amigadev.elowar.com/read/ADCD_2.1/Libraries_Manual_guide/node05BA.html}
}
\seealso{
Other AmigaBitmapFont.operations: \code{\link{availableFontSizes}},
  \code{\link{c}}, \code{\link{fontName}},
  \code{\link{font_example}},
  \code{\link{getAmigaBitmapFont}},
  \code{\link{rasterToAmigaBitmapFont}},
  \code{\link{rawToAmigaBitmapFontSet}},
  \code{\link{rawToAmigaBitmapFont}},
  \code{\link{read.AmigaBitmapFontSet}},
  \code{\link{read.AmigaBitmapFont}},
  \code{\link{write.AmigaBitmapFont}}

Other raster.operations: \code{\link{as.raster}},
  \code{\link{bitmapToRaster}}, \code{\link{dither}},
  \code{\link{index.colours}},
  \code{\link{rasterToAmigaBitmapFont}},
  \code{\link{rasterToBitmap}},
  \code{\link{rasterToHWSprite}}, \code{\link{rasterToIFF}}
}
\author{
Pepijn de Vries
}
