% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iff.0.r
\docType{methods}
\name{interpretIFFChunk}
\alias{interpretIFFChunk}
\alias{interpretIFFChunk,IFFChunk-method}
\title{Interpret an IFFChunk object}
\usage{
\S4method{interpretIFFChunk}{IFFChunk}(x, ...)
}
\arguments{
\item{x}{An \code{\link[=IFFChunk]{IFFChunk()}} object which needs to be interpreted.}

\item{...}{Currently ignored.}
}
\value{
If \code{x} is interpretable by this package an S3 class object of
\code{IFF.ANY} is returned. The content of the returned object will depend
on the type of \code{\link[=IFFChunk]{IFFChunk()}} provided for \code{x}. The result can
for instance be a \code{raster} image (\code{\link[grDevices:as.raster]{grDevices::as.raster()}}),
a list of audio \code{\link[tuneR:Wave]{tuneR::Wave()}}s, a \code{character} string or a named
\code{list}.
}
\description{
\code{\link[=IFFChunk]{IFFChunk()}}s represent the structure of the Interchange File Format well,
but the iformation is stored as \code{raw} data. This method tries to interpret and
translate the information into a more comprehensive format.
}
\details{
Interchange File Format chunks can hold any kind of information (images, audio,
(formatted) text, etc.). This method will try to convert this information into
something useful. Information may get lost in the translation, so be careful when
converting back to an \code{\link[=IFFChunk-class]{IFFChunk-class()}} object using
\code{\link[=IFFChunk-method]{IFFChunk-method()}}.

An error is thrown when the \code{\link[=IFFChunk]{IFFChunk()}} object is currently not
interpretable by this package. See \code{\link[=IFFChunk-method]{IFFChunk-method()}} for an overview
of currently supported IFF chunks. This list may increase while this package
matures.
}
\examples{
\dontrun{
## load an IFF file
example.iff <- read.iff(system.file("ilbm8lores.iff", package = "AmigaFFH"))

## in this case, the file is a FORM container with a bitmap image, and a
## list with a raster object is returned when interpreted:
example.itpt <- interpretIFFChunk(example.iff)
class(example.itpt)
typeof(example.itpt)
class(example.itpt[[1]])

## Let's extraxt the bitmap header from the main chunk:
bmhd <- getIFFChunk(example.iff, c("ILBM", "BMHD"))

## When interpreted, a named list is returned with (meta-)information
## on the bitmap image:
bmhd.itpt <- interpretIFFChunk(bmhd)
class(bmhd.itpt)
typeof(bmhd.itpt)
print(bmhd.itpt)
}
}
\seealso{
Other iff.operations: 
\code{\link{IFFChunk-class}},
\code{\link{WaveToIFF}()},
\code{\link{as.raster.AmigaBasicShape}()},
\code{\link{getIFFChunk}()},
\code{\link{rasterToIFF}()},
\code{\link{rawToIFFChunk}()},
\code{\link{read.iff}()},
\code{\link{write.iff}()}
}
\author{
Pepijn de Vries
}
\concept{iff.operations}
