% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.r
\name{read.AmigaBasic}
\alias{read.AmigaBasic}
\title{Read Amiga Basic files}
\usage{
read.AmigaBasic(file, disk = NULL, ...)
}
\arguments{
\item{file}{A \code{character} string of the filename of the Amiga Basic file to be read.}

\item{disk}{A virtual Commodore Amiga disk from which the \code{file} should be
read. This should be an \code{\link[adfExplorer:amigaDisk-class]{amigaDisk()}} object. Using
this argument requires the adfExplorer package.
When set to \code{NULL}, this argument is ignored.}

\item{...}{Currently ignored}
}
\value{
Returns an \code{\link[=AmigaBasic]{AmigaBasic()}} class object read from the \code{file}.
}
\description{
Read an \code{\link[=AmigaBasic]{AmigaBasic()}} script from its binary format.
}
\details{
Normally Amiga Basic code is stored encoded in a binary format
(\code{\link[=rawToAmigaBasic]{rawToAmigaBasic()}}).
This function reads the binary data from a file (which can be
stored on a virtual disk (\code{\link[adfExplorer:amigaDisk-class]{amigaDisk()}}))
and converts in into an \code{\link[=AmigaBasic]{AmigaBasic()}} class objec.
}
\examples{
\dontrun{
## First create an AmigaBasic file
write.AmigaBasic(as.AmigaBasic("PRINT \"Hello world\""),
                 file.path(tempdir(), "helloworld.bas"))

## Now let's read the same file:
bas <- read.AmigaBasic(file.path(tempdir(), "helloworld.bas"))
}

## There's also a demo file included with the package
demo.bas <- read.AmigaBasic(system.file("demo.bas", package = "AmigaFFH"))
demo.bas
}
\seealso{
Other AmigaBasic.operations: 
\code{\link{AmigaBasic.reserved}()},
\code{\link{AmigaBasicBMAP}},
\code{\link{AmigaBasic}},
\code{\link{[.AmigaBasic}()},
\code{\link{as.AmigaBasicBMAP}()},
\code{\link{as.AmigaBasic}()},
\code{\link{as.character}()},
\code{\link{check.names.AmigaBasic}()},
\code{\link{names.AmigaBasic}()},
\code{\link{rawToAmigaBasicBMAP}()},
\code{\link{rawToAmigaBasic}()},
\code{\link{read.AmigaBasicBMAP}()},
\code{\link{write.AmigaBasic}()}

Other io.operations: 
\code{\link{read.AmigaBasicBMAP}()},
\code{\link{read.AmigaBasicShape}()},
\code{\link{read.AmigaBitmapFontSet}()},
\code{\link{read.AmigaBitmapFont}()},
\code{\link{read.AmigaIcon}()},
\code{\link{read.SysConfig}()},
\code{\link{read.iff}()},
\code{\link{write.AmigaBasicShape}()},
\code{\link{write.AmigaBasic}()},
\code{\link{write.AmigaBitmapFont}()},
\code{\link{write.AmigaIcon}()},
\code{\link{write.SysConfig}()},
\code{\link{write.iff}()}
}
\author{
Pepijn de Vries
}
\concept{AmigaBasic.operations}
\concept{io.operations}
