% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DuncanTest.R
\name{DuncanTest}
\alias{DuncanTest}
\title{Duncan Multiple Range Test (DMRT) v2.0}
\usage{
DuncanTest(modelo, comparar = NULL, alpha = 0.05)
}
\arguments{
\item{modelo}{An \code{aov} or \code{lm} object (full model: includes blocks, factors, etc.).}

\item{comparar}{Character vector with the name(s) of the factor(s) to compare:
- One name: main effect (e.g., "treatment" or "A")
- Several names: interaction (e.g., \code{c("A","B")} for \code{A:B})
If omitted, it uses the first factor in \code{modelo$xlevels}.}

\item{alpha}{Significance level (default 0.05).}
}
\value{
An object of class \code{"duncan"} and \code{"comparaciones"} containing:
\itemize{
  \item \code{Resultados}: a data.frame with columns \code{Comparacion}, \code{Diferencia}, \code{SE}, \code{t_value},
        \code{p_value} (unadjusted), \code{p_ajustada} (duncan), \code{Valor_Critico} (critical difference), and \code{Significancia}.
  \item \code{Promedios}: a named vector of group means as defined by \code{comparar}.
  \item \code{Orden_Medias}: group names ordered from highest to lowest mean.
  \item \code{Metodo}: "Duncan t-test".
  \item \code{Termino}: the term being compared (e.g., "A", "B", or "A:B").
  \item \code{MSerror}, \code{df_error}, \code{N}: useful for plots with error bars.
}
}
\description{
Performs the Duncan test for pairwise comparisons after an ANOVA.
This method is more liberal than Tukey's HSD, using a stepwise approach
with critical values from the studentized range distribution.
}
\details{
Advantages:
- High power for detecting differences.
- Simple to interpret and implement.

Disadvantages:
- Inflates Type I error rate.
- Not recommended for confirmatory research.
}
\examples{

# DCA
data(d_e, package = "Analitica")
mod1 <- aov(Sueldo_actual ~ as.factor(labor), data = d_e)
resultado <- DuncanTest(mod1)
summary(resultado)
plot(resultado)

# DBA
mod2 <- aov(Sueldo_actual ~ as.factor(labor) + Sexo, data = d_e)
res <- DuncanTest(mod2, comparar = "as.factor(labor)")
summary(res); plot(res)

# DFactorial
mod3 <- aov(Sueldo_actual ~as.factor(labor) * Sexo, data = d_e)
resAB <- DuncanTest(mod3, comparar = c("as.factor(labor)","Sexo"))  # celdas A:B
summary(resAB, n = Inf); plot(resAB, horizontal = TRUE)

}
\references{
Duncan, D. B. (1955). "Multiple range and multiple F tests." Biometrics, 11(1), 1-42.
}
