% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FlignerKilleenTest.R
\name{FKTest}
\alias{FKTest}
\title{Fligner-Killeen Test for Homogeneity of Variances (Manual Implementation)}
\usage{
FKTest(formula, data, alpha = 0.05)
}
\arguments{
\item{formula}{A formula of the form \code{y ~ group}, where \code{y} is numeric
and \code{group} is a grouping variable (factor or coercible to factor).}

\item{data}{A data frame containing the variables in the formula.}

\item{alpha}{Significance level (default is 0.05).}
}
\value{
An object of class \code{"homocedasticidad"}, containing:
\describe{
  \item{Statistic}{The Fligner-Killeen chi-squared statistic.}
  \item{df}{Degrees of freedom.}
  \item{p_value}{The p-value for the test.}
  \item{Decision}{\code{"Homoscedastic"} or \code{"Heteroscedastic"} depending on the test result.}
  \item{Method}{A string indicating the method used ("Fligner-Killeen").}
}
}
\description{
Performs a non-parametric Fligner-Killeen test for equality of variances
across two or more groups, using raw vectors via a formula interface.
}
\details{
This test is particularly useful when the assumption of normality is violated,
as it is robust to outliers and distributional deviations. It serves as a reliable
alternative to Bartlett’s test when data do not follow a normal distribution.

Advantages:
- Non-parametric: No assumption of normality.
- Robust to outliers.
- Suitable for heterogeneous sample sizes.

Disadvantages:
- Less powerful than parametric tests under normality.
- May be computationally intensive with large datasets.
}
\examples{
data(d_e, package = "Analitica")
res <- FKTest(Sueldo_actual ~ labor, data = d_e)
summary(res)

}
\references{
Fligner, M. A., & Killeen, T. J. (1976). "Distribution-free two-sample tests for scale." \emph{Journal of the American Statistical Association}, 71(353), 210–213. <https://doi.org/10.1080/01621459.1976.10480351>
}
