% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NemenyiTest.R
\name{NemenyiTest}
\alias{NemenyiTest}
\title{Nemenyi Test for Multiple Comparisons (Non-Parametric)}
\usage{
NemenyiTest(formula, data, alpha = 0.05)
}
\arguments{
\item{formula}{A formula of the form \code{y ~ group}.}

\item{data}{A data frame containing the variables.}

\item{alpha}{Significance level (default is 0.05).}
}
\value{
An object of class \code{"nemenyi"} and \code{"comparaciones"}, including:
\itemize{
  \item \code{Resultados}: Data frame with group comparisons, rank differences, critical value, p-values, and significance codes.
  \item \code{Promedios}: Mean ranks of each group.
  \item \code{Orden_Medias}: Group names ordered from highest to lowest rank.
  \item \code{Metodo}: Name of the method ("Nemenyi (no paramétrico)").
}
}
\description{
Performs the Nemenyi test after a significant Kruskal-Wallis or Friedman test.
Based on the studentized range distribution applied to mean ranks.
}
\details{
Advantages:
- Easy to implement for equal-sized groups.
- Conservative control of family-wise error rate.

Disadvantages:
- Only valid with equal group sizes.
- No p-values are directly calculated (based on critical differences only).
}
\examples{
set.seed(123)
datos <- data.frame(
 grupo = rep(c("A", "B", "C", "D"), each = 10),
 medida = c(
   rnorm(10, mean = 10),
   rnorm(10, mean = 12),
   rnorm(10, mean = 15),
   rnorm(10, mean = 11)
 )
)
table(datos$grupo)
#> A  B  C  D
#>10 10 10 10
# Aplicar el test de Nemenyi
resultado <- NemenyiTest(medida ~ grupo, data = datos)
# Ver los resultados
summary(resultado)
# O simplemente
resultado$Resultados
# Ver orden de medias (rangos)
resultado$Orden_Medias



}
\references{
Nemenyi, P. (1963). Distribution-free Multiple Comparisons.
}
