% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AM_mix_hyperparams.R
\name{AM_mix_hyperparams_multinorm}
\alias{AM_mix_hyperparams_multinorm}
\title{multivariate Normal mixture hyperparameters}
\usage{
AM_mix_hyperparams_multinorm(mu0 = NULL, ka0 = NULL, nu0 = NULL, Lam0 = NULL)
}
\arguments{
\item{mu0}{The hyperparameter \eqn{\boldsymbol m_0}.}

\item{ka0}{The hyperparameter \eqn{\kappa_0}.}

\item{nu0}{The hyperparameter \eqn{\nu_0}.}

\item{Lam0}{The hyperparameter \eqn{\Lambda_0}.}
}
\value{
An \code{\link{AM_mix_hyperparams}} object. This is a configuration list to be used as \code{mix_kernel_hyperparams} argument for \code{\link{AM_mcmc_fit}}.
}
\description{
Generate a configuration object that specifies a multivariate Normal mixture kernel, where users can specify the hyperparameters for the conjugate prior of the multivariate
Normal mixture. We assume that the data are d-dimensional vectors \eqn{\boldsymbol{y}_i}, where \eqn{\boldsymbol{y}_i} are i.i.d
Normal random variables with mean \eqn{\boldsymbol{\mu}} and covariance matrix \eqn{\boldsymbol{\Sigma}}.
The conjugate prior is
\deqn{\pi(\boldsymbol \mu, \boldsymbol \Sigma\mid\boldsymbol m_0,\kappa_0,\nu_0,\boldsymbol \Lambda_0)= 
\pi_{\mu}(\boldsymbol \mu|\boldsymbol \Sigma,\boldsymbol m_0,\kappa_0)\pi_{\Sigma}(\boldsymbol \Sigma \mid \nu_0,\boldsymbol \Lambda_0),}
\deqn{ \pi_{\mu}(\boldsymbol \mu|\boldsymbol \Sigma,\boldsymbol m_0,\kappa_0)  = 
 \frac{\sqrt{\kappa_0^d}}{\sqrt {(2\pi )^{d}|{\boldsymbol \Sigma }|}} \exp \left(-{\frac {\kappa_0}{2}}(\boldsymbol\mu -{\boldsymbol m_0 })^{\mathrm {T} }{\boldsymbol{\Sigma }}^{-1}(\boldsymbol\mu-{\boldsymbol m_0 })\right),
\qquad \boldsymbol \mu\in\mathcal{R}^d,}
\deqn{\pi_{\Sigma}(\boldsymbol \Sigma\mid \nu_0,\boldsymbol \Lambda_0)= {\frac {\left|{\boldsymbol \Lambda_0 }\right|^{\nu_0 /2}}{2^{\nu_0 d/2}\Gamma _{d}({\frac {\nu_0 }{2}})}}\left|\boldsymbol \Sigma \right|^{-(\nu_0 +d+1)/2}e^{-{\frac {1}{2}}\mathrm {tr} (\boldsymbol \Lambda_0 \boldsymbol \Sigma^{-1})}
, \qquad \boldsymbol \Sigma^2>0,}
where \code{mu0} corresponds to \eqn{\boldsymbol m_0}, \code{ka0} corresponds to  \eqn{\kappa_0},
\code{nu0} to \eqn{\nu_0}, and \code{Lam0} to \eqn{\Lambda_0}.
}
\details{
Default is \code{(mu0=c(0,..,0)}, \code{ka0=1}, \code{nu0=Dim+2}, \code{Lam0=diag(Dim))} with \code{Dim} is the dimension of the data \code{y}.
We advise the user to set \eqn{\nu_0} equal to at least the dimension of the data, \code{Dim}, plus 2.
}
\examples{
AM_mix_hyperparams_multinorm ()
}
