% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel_to_ArCo_list.R
\name{panel_to_ArCo_list}
\alias{panel_to_ArCo_list}
\title{Transforms a balanced panel into a list of matrices compatible with the firArCo function}
\usage{
panel_to_ArCo_list(panel, time, unit, variables)
}
\arguments{
\item{panel}{Balanced panel in a data.frame with columns for units and time.}

\item{time}{Name or index of the time column.}

\item{unit}{Name or index of the unit column.}

\item{variables}{Names or indexes of the columns containing the variables.}
}
\description{
Transforms a balanced panel into a list of matrices compatible with the firArCo function. The user must identify the columns with the time, the unit identifier and the variables.
}
\examples{
# = Generate a small panel as example = #
set.seed(123)
time=sort(rep(1:100,2))
unit=rep(c("u1","u2"),100)
v1=rnorm(200)
v2=rnorm(200)
panel=data.frame(time=time,unit=unit,v1=v1,v2=v2)
head(panel)

data=panel_to_ArCo_list(panel,time="time",unit="unit",variables = c("v1","v2"))
head(data$v1)

}
\seealso{
\code{\link{fitArCo}}
}
