% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_beam_stats.R
\name{compute_beam_stats}
\alias{compute_beam_stats}
\title{Compute bootstrap model coefficients for BEAM}
\usage{
compute_beam_stats(beam.data, beam.specs, stdize = TRUE)
}
\arguments{
\item{beam.data}{Result of prep.beam.data}

\item{beam.specs}{A data.frame of strings with columns name, mtx, mdl (string with R model with mtx.row)}

\item{stdize}{Logical whether to standardize (center and scale) predictors or not. Default is TRUE.}
}
\value{
A beam.stats object, which is a list with beam.stats (the association matrices), the beam.specs, and the beam.data
}
\description{
Compute bootstrap model coefficients for BEAM
}
\examples{
data(beam_dat_sm)
data(beam_specs_sm)
test.beam.stats <- compute_beam_stats(beam.data=beam_dat_sm,
                                      beam.specs=beam_specs_sm, stdize=TRUE)
}
